package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import java.util.Comparator;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import java.nio.file.Path;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import java.util.stream.Collectors;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

public class KubernetesConfigAdapter{



    public static KubernetesConfig adapt(KubernetesApplication instance){
            return newBuilder(instance).build();
    }

    public static KubernetesConfigBuilder newBuilder(KubernetesApplication instance){
            return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(null,
            null,
            instance.group(),
            instance.name(),
            instance.version(),
            Arrays.asList(instance.labels()).stream().map(i ->new io.dekorate.kubernetes.config.Label(i.key(),
            i.value())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Label[0]),
            Arrays.asList(instance.annotations()).stream().map(i ->new io.dekorate.kubernetes.config.Annotation(i.key(),
            i.value())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Annotation[0]),
            Arrays.asList(instance.envVars()).stream().map(i ->new io.dekorate.kubernetes.config.Env(i.name(),
            i.value(),
            i.secret(),
            i.configmap(),
            i.field())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            instance.workingDir(),
            instance.command(),
            instance.arguments(),
            instance.serviceAccount(),
            instance.host(),
            Arrays.asList(instance.ports()).stream().map(i ->new io.dekorate.kubernetes.config.Port(i.name(),
            i.containerPort(),
            i.hostPort(),
            i.path(),
            i.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            instance.serviceType(),
            Arrays.asList(instance.pvcVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(i.volumeName(),
            i.claimName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[0]),
            Arrays.asList(instance.secretVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.SecretVolume(i.volumeName(),
            i.secretName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.SecretVolume[0]),
            Arrays.asList(instance.configMapVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(i.volumeName(),
            i.configMapName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.ConfigMapVolume[0]),
            Arrays.asList(instance.gitRepoVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(i.volumeName(),
            i.repository(),
            i.directory(),
            i.revision())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.GitRepoVolume[0]),
            Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(i.volumeName(),
            i.volumeId(),
            i.partition(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[0]),
            Arrays.asList(instance.azureDiskVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(i.volumeName(),
            i.diskName(),
            i.diskURI(),
            i.kind(),
            i.cachingMode(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureDiskVolume[0]),
            Arrays.asList(instance.azureFileVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(i.volumeName(),
            i.shareName(),
            i.secretName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureFileVolume[0]),
            Arrays.asList(instance.mounts()).stream().map(i ->new io.dekorate.kubernetes.config.Mount(i.name(),
            i.path(),
            i.subPath(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            instance.imagePullPolicy(),
            instance.imagePullSecrets(),
            new io.dekorate.kubernetes.config.Probe(instance.livenessProbe().httpActionPath(),
            instance.livenessProbe().execAction(),
            instance.livenessProbe().tcpSocketAction(),
            instance.livenessProbe().initialDelaySeconds(),
            instance.livenessProbe().periodSeconds(),
            instance.livenessProbe().timeoutSeconds(),
            instance.livenessProbe().successThreshold(),
            instance.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(instance.readinessProbe().httpActionPath(),
            instance.readinessProbe().execAction(),
            instance.readinessProbe().tcpSocketAction(),
            instance.readinessProbe().initialDelaySeconds(),
            instance.readinessProbe().periodSeconds(),
            instance.readinessProbe().timeoutSeconds(),
            instance.readinessProbe().successThreshold(),
            instance.readinessProbe().failureThreshold()),
            Arrays.asList(instance.sidecars()).stream().map(i ->new io.dekorate.kubernetes.config.Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.expose(),
            instance.autoDeployEnabled(),
            Arrays.asList(instance.initContainers()).stream().map(i ->new io.dekorate.kubernetes.config.Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.replicas(),
            instance.headless()));
    }

    public static KubernetesConfig adapt(Map map){
            return new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", "") : ""),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("host", "") : ""),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("hostPort","0") : "0")),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               ServiceType.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("serviceType","ClusterIP") : "ClusterIP")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("defaultMode","384") : "384")),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("optional","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("defaultMode","384") : "384")),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("optional","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("partition","0") : "0")),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("imagePullSecrets", new java.lang.String[0]) : new java.lang.String[0]),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("hostPort","0") : "0")),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("expose","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("hostPort","0") : "0")),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("replicas","1") : "1")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("headless","false") : "false")));
    }

    public static KubernetesConfigBuilder newBuilder(Map map){
            return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", "") : ""),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("host", "") : ""),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("hostPort","0") : "0")),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               ServiceType.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("serviceType","ClusterIP") : "ClusterIP")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("defaultMode","384") : "384")),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("optional","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("defaultMode","384") : "384")),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("optional","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               Integer.parseInt(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("partition","0") : "0")),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
               (String[])(map instanceof Map ? ((Map)map).getOrDefault("imagePullSecrets", new java.lang.String[0]) : new java.lang.String[0]),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("hostPort","0") : "0")),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("expose","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("command", new java.lang.String[0]) : new java.lang.String[0]),
               (String[])(i instanceof Map ? ((Map)i).getOrDefault("arguments", new java.lang.String[0]) : new java.lang.String[0]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("containerPort","0") : "0")),
               Integer.parseInt(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("hostPort","0") : "0")),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               Boolean.parseBoolean(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("readOnly","false") : "false")))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))),
new io.dekorate.kubernetes.config.Probe(
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds","0") : "0")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds","30") : "30")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds","10") : "10")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold","1") : "1")),
                   Integer.parseInt(String.valueOf(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold","3") : "3"))))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("replicas","1") : "1")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("headless","false") : "false"))));
    }




}
