package io.dekorate.kubernetes.config;

import java.lang.String;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Object;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class KubernetesConfig extends BaseConfig{

    private io.dekorate.kubernetes.config.Container[] initContainers = new io.dekorate.kubernetes.config.Container[0];
    private int replicas = 1;
    private boolean headless = false;

    public KubernetesConfig(){
    }
    public KubernetesConfig(Project project,Map<ConfigKey,Object> attributes,String group,String name,String version,io.dekorate.kubernetes.config.Label[] labels,io.dekorate.kubernetes.config.Annotation[] annotations,io.dekorate.kubernetes.config.Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,String host,io.dekorate.kubernetes.config.Port[] ports,ServiceType serviceType,io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[] pvcVolumes,io.dekorate.kubernetes.config.SecretVolume[] secretVolumes,io.dekorate.kubernetes.config.ConfigMapVolume[] configMapVolumes,io.dekorate.kubernetes.config.GitRepoVolume[] gitRepoVolumes,io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,io.dekorate.kubernetes.config.AzureDiskVolume[] azureDiskVolumes,io.dekorate.kubernetes.config.AzureFileVolume[] azureFileVolumes,io.dekorate.kubernetes.config.Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,io.dekorate.kubernetes.config.Probe livenessProbe,io.dekorate.kubernetes.config.Probe readinessProbe,io.dekorate.kubernetes.config.Container[] sidecars,boolean expose,boolean autoDeployEnabled,io.dekorate.kubernetes.config.Container[] initContainers,int replicas,boolean headless){
            super(project, attributes, group, name, version, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, host, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, livenessProbe, readinessProbe, sidecars, expose, autoDeployEnabled);
            this.initContainers = initContainers != null ? initContainers : new io.dekorate.kubernetes.config.Container[0];
            this.replicas = replicas;
            this.headless = headless;
    }

    public io.dekorate.kubernetes.config.Container[] getInitContainers(){
            return this.initContainers;
    }

    public int getReplicas(){
            return this.replicas;
    }

    public boolean isHeadless(){
            return this.headless;
    }




}
