package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesConfigBuilder extends KubernetesConfigFluentImpl<KubernetesConfigBuilder> implements VisitableBuilder<KubernetesConfig,KubernetesConfigBuilder>{

    KubernetesConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesConfigBuilder(){
            this(true);
    }
    public KubernetesConfigBuilder(Boolean validationEnabled){
            this(new KubernetesConfig(), validationEnabled);
    }
    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesConfig(), validationEnabled);
    }
    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,KubernetesConfig instance){
            this(fluent, instance, true);
    }
    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,KubernetesConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject()); 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withName(instance.getName()); 
            fluent.withVersion(instance.getVersion()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withAnnotations(instance.getAnnotations()); 
            fluent.withEnvVars(instance.getEnvVars()); 
            fluent.withWorkingDir(instance.getWorkingDir()); 
            fluent.withCommand(instance.getCommand()); 
            fluent.withArguments(instance.getArguments()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withHost(instance.getHost()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withServiceType(instance.getServiceType()); 
            fluent.withPvcVolumes(instance.getPvcVolumes()); 
            fluent.withSecretVolumes(instance.getSecretVolumes()); 
            fluent.withConfigMapVolumes(instance.getConfigMapVolumes()); 
            fluent.withGitRepoVolumes(instance.getGitRepoVolumes()); 
            fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
            fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
            fluent.withAzureFileVolumes(instance.getAzureFileVolumes()); 
            fluent.withMounts(instance.getMounts()); 
            fluent.withImagePullPolicy(instance.getImagePullPolicy()); 
            fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
            fluent.withLivenessProbe(instance.getLivenessProbe()); 
            fluent.withReadinessProbe(instance.getReadinessProbe()); 
            fluent.withSidecars(instance.getSidecars()); 
            fluent.withExpose(instance.isExpose()); 
            fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            fluent.withInitContainers(instance.getInitContainers()); 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withHeadless(instance.isHeadless()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesConfigBuilder(KubernetesConfig instance){
            this(instance,true);
    }
    public KubernetesConfigBuilder(KubernetesConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withGroup(instance.getGroup()); 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.withLabels(instance.getLabels()); 
            this.withAnnotations(instance.getAnnotations()); 
            this.withEnvVars(instance.getEnvVars()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.withCommand(instance.getCommand()); 
            this.withArguments(instance.getArguments()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withHost(instance.getHost()); 
            this.withPorts(instance.getPorts()); 
            this.withServiceType(instance.getServiceType()); 
            this.withPvcVolumes(instance.getPvcVolumes()); 
            this.withSecretVolumes(instance.getSecretVolumes()); 
            this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
            this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
            this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
            this.withMounts(instance.getMounts()); 
            this.withImagePullPolicy(instance.getImagePullPolicy()); 
            this.withImagePullSecrets(instance.getImagePullSecrets()); 
            this.withLivenessProbe(instance.getLivenessProbe()); 
            this.withReadinessProbe(instance.getReadinessProbe()); 
            this.withSidecars(instance.getSidecars()); 
            this.withExpose(instance.isExpose()); 
            this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.withInitContainers(instance.getInitContainers()); 
            this.withReplicas(instance.getReplicas()); 
            this.withHeadless(instance.isHeadless()); 
            this.validationEnabled = validationEnabled; 
    }

    public EditableKubernetesConfig build(){
            EditableKubernetesConfig buildable = new EditableKubernetesConfig(fluent.getProject(),fluent.getAttributes(),fluent.getGroup(),fluent.getName(),fluent.getVersion(),fluent.getLabels(),fluent.getAnnotations(),fluent.getEnvVars(),fluent.getWorkingDir(),fluent.getCommand(),fluent.getArguments(),fluent.getServiceAccount(),fluent.getHost(),fluent.getPorts(),fluent.getServiceType(),fluent.getPvcVolumes(),fluent.getSecretVolumes(),fluent.getConfigMapVolumes(),fluent.getGitRepoVolumes(),fluent.getAwsElasticBlockStoreVolumes(),fluent.getAzureDiskVolumes(),fluent.getAzureFileVolumes(),fluent.getMounts(),fluent.getImagePullPolicy(),fluent.getImagePullSecrets(),fluent.getLivenessProbe(),fluent.getReadinessProbe(),fluent.getSidecars(),fluent.isExpose(),fluent.isAutoDeployEnabled(),fluent.getInitContainers(),fluent.getReplicas(),fluent.isHeadless());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesConfigBuilder that = (KubernetesConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
