package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KubernetesConfigFluentImpl<A extends KubernetesConfigFluent<A>> extends BaseConfigFluentImpl<A> implements KubernetesConfigFluent<A>{

    private List<ContainerBuilder> initContainers =  new ArrayList<ContainerBuilder>();
    private int replicas = 1;
    private boolean headless = false;

    public KubernetesConfigFluentImpl(){
    }
    public KubernetesConfigFluentImpl(KubernetesConfig instance){
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withGroup(instance.getGroup()); 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.withLabels(instance.getLabels()); 
            this.withAnnotations(instance.getAnnotations()); 
            this.withEnvVars(instance.getEnvVars()); 
            this.withWorkingDir(instance.getWorkingDir()); 
            this.withCommand(instance.getCommand()); 
            this.withArguments(instance.getArguments()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withHost(instance.getHost()); 
            this.withPorts(instance.getPorts()); 
            this.withServiceType(instance.getServiceType()); 
            this.withPvcVolumes(instance.getPvcVolumes()); 
            this.withSecretVolumes(instance.getSecretVolumes()); 
            this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
            this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
            this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
            this.withMounts(instance.getMounts()); 
            this.withImagePullPolicy(instance.getImagePullPolicy()); 
            this.withImagePullSecrets(instance.getImagePullSecrets()); 
            this.withLivenessProbe(instance.getLivenessProbe()); 
            this.withReadinessProbe(instance.getReadinessProbe()); 
            this.withSidecars(instance.getSidecars()); 
            this.withExpose(instance.isExpose()); 
            this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.withInitContainers(instance.getInitContainers()); 
            this.withReplicas(instance.getReplicas()); 
            this.withHeadless(instance.isHeadless()); 
    }

    public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers){
            if (this.initContainers != null) {this.initContainers.clear();}
            if (initContainers != null) {for (io.dekorate.kubernetes.config.Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 */
@Deprecated public io.dekorate.kubernetes.config.Container[] getInitContainers(){
            int size = initContainers != null ? initContainers.size() : 0;
io.dekorate.kubernetes.config.Container[] result = new io.dekorate.kubernetes.config.Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.kubernetes.config.Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.kubernetes.config.Container[] buildInitContainers(){
            int size = initContainers != null ? initContainers.size() : 0;
io.dekorate.kubernetes.config.Container[] result = new io.dekorate.kubernetes.config.Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.kubernetes.config.Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.kubernetes.config.Container buildInitContainer(int index){
            return this.initContainers.get(index).build();
    }

    public io.dekorate.kubernetes.config.Container buildFirstInitContainer(){
            return this.initContainers.get(0).build();
    }

    public io.dekorate.kubernetes.config.Container buildLastInitContainer(){
            return this.initContainers.get(initContainers.size() - 1).build();
    }

    public io.dekorate.kubernetes.config.Container buildMatchingInitContainer(io.dekorate.deps.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            for (ContainerBuilder item: initContainers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInitContainer(io.dekorate.deps.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            for (ContainerBuilder item: initContainers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A addToInitContainers(int index,io.dekorate.kubernetes.config.Container item){
            if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
            io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
    }

    public A setToInitContainers(int index,io.dekorate.kubernetes.config.Container item){
            if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
            io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);
            if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
            if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
             return (A)this;
    }

    public A addToInitContainers(io.dekorate.kubernetes.config.Container... items){
            if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
            for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A addAllToInitContainers(Collection<io.dekorate.kubernetes.config.Container> items){
            if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
            for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items){
            for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<io.dekorate.kubernetes.config.Container> items){
            for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInitContainers(io.dekorate.deps.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            if (initContainers == null) return (A) this;
            final Iterator<ContainerBuilder> each = initContainers.iterator();
            final List visitables = _visitables.get("initContainers");
            while (each.hasNext()) {
              ContainerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public Boolean hasInitContainers(){
            return initContainers != null && !initContainers.isEmpty();
    }

    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer(){
            return new InitContainersNestedImpl();
    }

    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(io.dekorate.kubernetes.config.Container item){
            return new InitContainersNestedImpl(-1, item);
    }

    public KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(int index,io.dekorate.kubernetes.config.Container item){
            return new InitContainersNestedImpl(index, item);
    }

    public KubernetesConfigFluent.InitContainersNested<A> editInitContainer(int index){
            if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer(){
            if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
            return setNewInitContainerLike(0, buildInitContainer(0));
    }

    public KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer(){
            int index = initContainers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(io.dekorate.deps.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            int index = -1;
            for (int i=0;i<initContainers.size();i++) { 
            if (predicate.apply(initContainers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public int getReplicas(){
            return this.replicas;
    }

    public A withReplicas(int replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return true;
    }

    public boolean isHeadless(){
            return this.headless;
    }

    public A withHeadless(boolean headless){
            this.headless=headless; return (A) this;
    }

    public Boolean hasHeadless(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesConfigFluentImpl that = (KubernetesConfigFluentImpl) o;
            if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
            if (replicas != that.replicas) return false;
            if (headless != that.headless) return false;
            return true;
    }


    public class InitContainersNestedImpl<N> extends ContainerFluentImpl<KubernetesConfigFluent.InitContainersNested<N>> implements KubernetesConfigFluent.InitContainersNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N>{

            private final ContainerBuilder builder;
        private final int index;
    
            InitContainersNestedImpl(int index,io.dekorate.kubernetes.config.Container item){
                    this.index = index;
                    this.builder = new ContainerBuilder(this, item);
            }
            InitContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new ContainerBuilder(this);
            }
    
    public N and(){
            return (N) KubernetesConfigFluentImpl.this.setToInitContainers(index, builder.build());
    }
    public N endInitContainer(){
            return and();
    }

}


}
