/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigurationFluentImpl<A extends ConfigurationFluent<A>>
extends BaseFluent<A>
implements ConfigurationFluent<A> {
    private Project project;
    private Map<ConfigKey, Object> attributes;

    public ConfigurationFluentImpl() {
    }

    public ConfigurationFluentImpl(Configuration instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public A withProject(Project project) {
        this.project = project;
        return (A)this;
    }

    @Override
    public Boolean hasProject() {
        return this.project != null;
    }

    @Override
    public A addToAttributes(ConfigKey key, Object value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttributes(ConfigKey key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (ConfigKey key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<ConfigKey, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public A withAttributes(Map<ConfigKey, Object> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<ConfigKey, Object>(attributes);
        return (A)this;
    }

    @Override
    public Boolean hasAttributes() {
        return this.attributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationFluentImpl that = (ConfigurationFluentImpl)o;
        if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
            return false;
        }
        return !(this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null);
    }
}

