/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ApplicationResourceDecorator;
import io.dekorate.utils.Strings;

@Description(value="Apply the service account.")
public class ApplyServiceAccountDecorator
extends ApplicationResourceDecorator<PodSpecFluent> {
    private final String serviceAccount;

    public ApplyServiceAccountDecorator(String resourceName, String serviceAccount) {
        super(resourceName);
        this.serviceAccount = serviceAccount;
    }

    @Override
    public void andThenVisit(PodSpecFluent podSpec) {
        if (Strings.isNotNullOrEmpty((String)this.serviceAccount)) {
            podSpec.withServiceAccount(this.serviceAccount);
        }
    }
}

