/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.listener;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.DekorateException;
import io.dekorate.Resources;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.hook.ImageBuildHook;
import io.dekorate.hook.ImagePushHook;
import io.dekorate.hook.OrderedHook;
import io.dekorate.hook.ProjectHook;
import io.dekorate.hook.ResourcesApplyHook;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.hook.ScaleDeploymentHook;
import io.dekorate.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class KubernetesSessionListener
implements SessionListener,
WithProject,
WithSession {
    private static final String KUBERNETES = "kubernetes";

    public void onClosed() {
        Session session = this.getSession();
        Project project = this.getProject();
        Optional optionalAppConfig = session.configurators().get(KubernetesConfig.class);
        Optional optionalImageConfig = session.configurators().getImageConfig(BuildServiceFactories.supplierMatches((Project)project));
        if (!optionalAppConfig.isPresent() || !optionalImageConfig.isPresent()) {
            return;
        }
        KubernetesConfig kubernetesConfig = (KubernetesConfig)optionalAppConfig.get();
        Resources resources = session.resources();
        KubernetesList generated = session.getGeneratedResources().getOrDefault(KUBERNETES, new KubernetesList());
        BuildService buildService = null;
        ImageConfiguration imageConfig = (ImageConfiguration)optionalImageConfig.get();
        if (imageConfig.isAutoPushEnabled() || imageConfig.isAutoBuildEnabled() || kubernetesConfig.isAutoDeployEnabled()) {
            try {
                buildService = (BuildService)optionalImageConfig.map(BuildServiceFactories.create((Project)this.getProject(), (Collection)generated.getItems())).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
            }
            catch (Exception e) {
                BuildServiceFactories.log((Project)project, (Collection)session.configurators().getAll(ImageConfiguration.class));
                throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
            }
        }
        ArrayList<Object> hooks = new ArrayList<Object>();
        if (kubernetesConfig.isAutoDeployEnabled()) {
            hooks.add(new ResourcesApplyHook(this.getProject(), KUBERNETES, "kubectl"));
            hooks.add((Object)new ScaleDeploymentHook(this.getProject(), session.resources().getName(), 0));
        }
        if (imageConfig.isAutoPushEnabled()) {
            hooks.add(new ImageBuildHook(this.getProject(), buildService));
            hooks.add(new ImagePushHook(this.getProject(), buildService));
        } else if (imageConfig.isAutoBuildEnabled() || kubernetesConfig.isAutoDeployEnabled()) {
            hooks.add(new ImageBuildHook(this.getProject(), buildService));
        }
        if (kubernetesConfig.isAutoDeployEnabled()) {
            hooks.add((Object)new ScaleDeploymentHook(this.getProject(), session.resources().getName(), 1));
        }
        OrderedHook hook = OrderedHook.create((ProjectHook[])hooks.toArray(new ProjectHook[hooks.size()]));
        hook.register();
    }
}

