/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import java.util.Objects;

@Description(value="Add a label to the all metadata.")
public class AddLabelDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final Label label;

    public AddLabelDecorator(Label label) {
        this(ANY, label);
    }

    public AddLabelDecorator(String name, Label label) {
        super(name);
        this.label = label;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        builder.addToLabels(this.label.getKey(), this.label.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddLabelDecorator addLabelDecorator = (AddLabelDecorator)o;
        return Objects.equals(this.label, addLabelDecorator.label);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }
}

