/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleBindingFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

@Description(value="Add a Rolebinding resource to the list of generated resources.")
public class AddRoleBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String DEFAULT_RBAC_API_GROUP = "rbac.authorization.k8s.io";
    private final String role;

    public AddRoleBindingResourceDecorator(String role) {
        this.role = role;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        list.addToItems((VisitableBuilder)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(meta.getName() + ":view")).withLabels(meta.getLabels())).endMetadata()).withNewRoleRef().withKind("ClusterRole")).withName(this.role)).withApiGroup(DEFAULT_RBAC_API_GROUP)).endRoleRef()).addNewSubject().withKind("ServiceAccount")).withName(meta.getName())).endSubject());
    }
}

