/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.jackson.annotation.JsonTypeInfo;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.project.Project;
import io.dekorate.utils.Strings;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ImageConfiguration
extends ApplicationConfiguration {
    private String registry;
    private String group;
    private String name;
    private String version;
    private String image;
    private String dockerFile;
    private boolean autoBuildEnabled;
    private boolean autoPushEnabled;

    public static ImageConfiguration from(ApplicationConfiguration applicationConfiguration) {
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(applicationConfiguration.getProject())).withName(applicationConfiguration.getName())).withVersion(applicationConfiguration.getVersion())).withAttributes(applicationConfiguration.getAttributes())).build();
    }

    public ImageConfiguration() {
    }

    public ImageConfiguration(Project project, Map<ConfigKey, Object> attributes, String registry, String group, String name, String version, String image, String dockerFile, boolean autoBuildEnabled, boolean autoPushEnabled) {
        super(project, attributes, group, name, version);
        this.registry = registry;
        this.group = Strings.isNotNullOrEmpty((String)group) ? group : System.getProperty("user.name");
        this.name = name;
        this.version = Strings.isNotNullOrEmpty((String)version) ? version : "latest";
        this.image = image;
        this.dockerFile = dockerFile;
        this.autoBuildEnabled = autoBuildEnabled;
        this.autoPushEnabled = autoPushEnabled;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDockerFile() {
        return this.dockerFile;
    }

    public void setDockerFile(String dockerFile) {
        this.dockerFile = dockerFile;
    }

    public boolean isAutoBuildEnabled() {
        return this.autoBuildEnabled;
    }

    public void setAutoBuildEnabled(boolean autoBuildEnabled) {
        this.autoBuildEnabled = autoBuildEnabled;
    }

    public boolean isAutoPushEnabled() {
        return this.autoPushEnabled;
    }

    public void setAutoPushEnabled(boolean autoPushEnabled) {
        this.autoPushEnabled = autoPushEnabled;
    }
}

