/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.AccessMode;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.PersistentVolumeClaimConfigBuilder;
import io.dekorate.project.Project;
import java.util.Map;

public class PersistentVolumeClaimConfig
extends ApplicationConfiguration {
    private int size = 1;
    private String unit = "Gi";
    private String storageClass = "standard";
    private AccessMode accessMode = AccessMode.ReadWriteOnce;
    private Label[] matchLabels = new Label[0];

    public PersistentVolumeClaimConfig() {
    }

    public PersistentVolumeClaimConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, int size, String unit, String storageClass, AccessMode accessMode, Label[] matchLabels) {
        super(project, attributes, partOf, name, version);
        this.size = size;
        this.unit = unit != null ? unit : "Gi";
        this.storageClass = storageClass != null ? storageClass : "standard";
        this.accessMode = accessMode != null ? accessMode : AccessMode.ReadWriteOnce;
        this.matchLabels = matchLabels != null ? matchLabels : new Label[]{};
    }

    public int getSize() {
        return this.size;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Label[] getMatchLabels() {
        return this.matchLabels;
    }

    public static PersistentVolumeClaimConfigBuilder newPersistentVolumeClaimConfigBuilder() {
        return new PersistentVolumeClaimConfigBuilder();
    }
}

