/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ApplyPortNameDecorator
extends ApplicationContainerDecorator<PortFluent<?>> {
    private final String name;
    private final Set<String> toReplace;

    public ApplyPortNameDecorator(String deploymentName, String containerName, String name, String ... toReplace) {
        super(deploymentName, containerName);
        this.name = name;
        this.toReplace = new HashSet<String>(Arrays.asList(toReplace));
    }

    @Override
    public void andThenVisit(PortFluent<?> port) {
        if (this.toReplace.contains(port.getName())) {
            port.withName(this.name);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplicationContainerDecorator.class, AddSidecarDecorator.class, AddPortDecorator.class};
    }
}

