/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import java.util.Arrays;
import java.util.Objects;

public class AddHostAliasesDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final HostAlias hostAlias;

    public AddHostAliasesDecorator(String deploymentName, HostAlias hostAlias) {
        super(deploymentName);
        this.hostAlias = hostAlias;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.hostAlias.getIp()) && Strings.isNotNullOrEmpty((String)this.hostAlias.getHostnames())) {
            Predicate matchingHostAlias = host -> {
                if (host.getIp() != null) {
                    return host.getIp().equals(this.hostAlias.getIp());
                }
                return false;
            };
            podSpec.removeMatchingFromHostAliases(matchingHostAlias);
            ((PodSpecFluent.HostAliasesNested)((PodSpecFluent.HostAliasesNested)podSpec.addNewHostAlias().withIp(this.hostAlias.getIp())).withHostnames(Arrays.asList(this.hostAlias.getHostnames().split(",")))).endHostAlias();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddHostAliasesDecorator that = (AddHostAliasesDecorator)o;
        return Objects.equals(this.hostAlias, that.hostAlias);
    }

    public int hashCode() {
        return Objects.hash(this.hostAlias);
    }
}

