/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.deps.kubernetes.api.model.BaseKubernetesListFluent;
import io.dekorate.deps.kubernetes.api.model.IntOrString;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ServiceFluent;
import io.dekorate.deps.kubernetes.api.model.ServicePort;
import io.dekorate.deps.kubernetes.api.model.ServicePortBuilder;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Labels;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Description(value="Add a service to the list.")
public class AddServiceResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private final BaseConfig config;

    public AddServiceResourceDecorator(BaseConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "v1", "Service", this.config.getName())) {
            return;
        }
        ((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)list.addNewServiceItem().withNewMetadata().withName(this.config.getName())).withLabels(Labels.createLabels((BaseConfig)this.config))).endMetadata()).withNewSpec().withType(this.config.getServiceType().name())).withSelector(Labels.createLabels((BaseConfig)this.config))).withPorts(Arrays.asList(this.config.getPorts()).stream().filter(AddServiceResourceDecorator.distinct(p -> p.getName())).map(this::toServicePort).collect(Collectors.toList()))).endSpec()).endServiceItem();
    }

    private ServicePort toServicePort(Port port) {
        return ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(port.getName())).withPort(Integer.valueOf(port.getContainerPort()))).withTargetPort(new IntOrString(Integer.valueOf(port.getHostPort() > 0 ? port.getHostPort() : port.getContainerPort())))).build();
    }

    public static <T> Predicate<T> distinct(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object key = keyExtractor.apply(t);
            if (key == null) {
                LOGGER.warning("Found incomplete port definition (name is missing). The port will be ignored.");
                return false;
            }
            return map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        };
    }
}

