/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

@Description(value="A decorator that applies the command args to the application container.")
public class ApplyArgsDecorator
extends ApplicationContainerDecorator<ContainerFluent> {
    private final String[] argument;

    public ApplyArgsDecorator(String containerName, String ... argument) {
        super(null, containerName);
        this.argument = argument;
    }

    public ApplyArgsDecorator(String deploymentName, String containerName, String ... argument) {
        super(deploymentName, containerName);
        this.argument = argument;
    }

    @Override
    public void andThenVisit(ContainerFluent container) {
        if (this.isApplicable(container) && this.argument != null && this.argument.length > 0) {
            container.withArgs(this.argument);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class};
    }
}

