/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.Quantity;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

public class ApplyRequestsCpuDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private static final String CPU = "cpu";
    private final String amount;

    public ApplyRequestsCpuDecorator(String containerName, String amount) {
        super(containerName);
        this.amount = amount;
    }

    public ApplyRequestsCpuDecorator(String deploymentName, String containerName, String amount) {
        super(deploymentName, containerName);
        this.amount = amount;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        ((ContainerFluent.ResourcesNested)container.editOrNewResources().addToRequests(CPU, new Quantity(this.amount))).endResources();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class};
    }
}

