/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

@Description(value="Add a label to the all metadata.")
public class AddLabelDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final Label label;

    public AddLabelDecorator(Label label) {
        this(ANY, label);
    }

    public AddLabelDecorator(String name, Label label) {
        this(ANY, name, label);
    }

    public AddLabelDecorator(String kind, String name, Label label) {
        super(kind, name);
        this.label = label;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        builder.addToLabels(this.label.getKey(), this.label.getValue());
    }

    public Label getLabel() {
        return this.label;
    }

    public String getLabelKey() {
        return this.label.getKey();
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveLabelDecorator.class};
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ContainerDecorator.class, AddSidecarDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddLabelDecorator other = (AddLabelDecorator)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

