/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;
import io.dekorate.kubernetes.config.EditableBaseConfig;

public class BaseConfigBuilder
extends BaseConfigFluentImpl<BaseConfigBuilder>
implements VisitableBuilder<BaseConfig, BaseConfigBuilder> {
    BaseConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BaseConfigBuilder() {
        this(true);
    }

    public BaseConfigBuilder(Boolean validationEnabled) {
        this(new BaseConfig(), validationEnabled);
    }

    public BaseConfigBuilder(BaseConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BaseConfigBuilder(BaseConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BaseConfig(), validationEnabled);
    }

    public BaseConfigBuilder(BaseConfigFluent<?> fluent, BaseConfig instance) {
        this(fluent, instance, true);
    }

    public BaseConfigBuilder(BaseConfigFluent<?> fluent, BaseConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withPartOf(instance.getPartOf());
        fluent.withName(instance.getName());
        fluent.withVersion(instance.getVersion());
        fluent.withLabels(instance.getLabels());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withEnvVars(instance.getEnvVars());
        fluent.withWorkingDir(instance.getWorkingDir());
        fluent.withCommand(instance.getCommand());
        fluent.withArguments(instance.getArguments());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withHost(instance.getHost());
        fluent.withPorts(instance.getPorts());
        fluent.withServiceType(instance.getServiceType());
        fluent.withPvcVolumes(instance.getPvcVolumes());
        fluent.withSecretVolumes(instance.getSecretVolumes());
        fluent.withConfigMapVolumes(instance.getConfigMapVolumes());
        fluent.withGitRepoVolumes(instance.getGitRepoVolumes());
        fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        fluent.withAzureFileVolumes(instance.getAzureFileVolumes());
        fluent.withMounts(instance.getMounts());
        fluent.withImagePullPolicy(instance.getImagePullPolicy());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withSidecars(instance.getSidecars());
        fluent.withExpose(instance.isExpose());
        fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.validationEnabled = validationEnabled;
    }

    public BaseConfigBuilder(BaseConfig instance) {
        this(instance, (Boolean)true);
    }

    public BaseConfigBuilder(BaseConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withHost(instance.getHost());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withSidecars(instance.getSidecars());
        this.withExpose(instance.isExpose());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.validationEnabled = validationEnabled;
    }

    public EditableBaseConfig build() {
        EditableBaseConfig buildable = new EditableBaseConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getPartOf(), this.fluent.getName(), this.fluent.getVersion(), this.fluent.getLabels(), this.fluent.getAnnotations(), this.fluent.getEnvVars(), this.fluent.getWorkingDir(), this.fluent.getCommand(), this.fluent.getArguments(), this.fluent.getServiceAccount(), this.fluent.getHost(), this.fluent.getPorts(), this.fluent.getServiceType(), this.fluent.getPvcVolumes(), this.fluent.getSecretVolumes(), this.fluent.getConfigMapVolumes(), this.fluent.getGitRepoVolumes(), this.fluent.getAwsElasticBlockStoreVolumes(), this.fluent.getAzureDiskVolumes(), this.fluent.getAzureFileVolumes(), this.fluent.getMounts(), this.fluent.getImagePullPolicy(), this.fluent.getImagePullSecrets(), this.fluent.getLivenessProbe(), this.fluent.getReadinessProbe(), this.fluent.getSidecars(), this.fluent.isExpose(), this.fluent.isAutoDeployEnabled());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseConfigBuilder that = (BaseConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

