/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import java.util.Objects;

@Description(value="A decorator that adds an annotation to all resources.")
public class AddAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final Annotation annotation;

    public AddAnnotationDecorator(Annotation annotation) {
        this(ANY, annotation);
    }

    public AddAnnotationDecorator(String name, Annotation annotation) {
        this(ANY, name, annotation);
    }

    public AddAnnotationDecorator(String kind, String name, Annotation annotation) {
        super(kind, name);
        this.annotation = annotation;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        builder.addToAnnotations(this.annotation.getKey(), this.annotation.getValue());
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveAnnotationDecorator.class};
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ContainerDecorator.class, AddSidecarDecorator.class};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddAnnotationDecorator that = (AddAnnotationDecorator)o;
        return Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }
}

