/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.TypedVisitor;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRuleBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressRuleFluent;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.extensions.IngressSpecFluent;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;

public class AddIngressRuleDecorator
extends NamedResourceDecorator<IngressSpecBuilder> {
    private final String host;
    private final Port port;

    public AddIngressRuleDecorator(String name, String host, Port port) {
        super(name);
        this.host = host;
        this.port = port;
    }

    @Override
    public void andThenVisit(IngressSpecBuilder spec, ObjectMeta meta) {
        Predicate matchingHost = r -> r.getHost().equals(this.host);
        if (!spec.hasMatchingRule(matchingHost).booleanValue()) {
            ((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)spec.addNewRule().withHost(this.host)).withNewHttp().addNewPath().withPath(this.port.getPath())).withNewBackend().withServiceName(meta.getName())).withNewServicePort(Integer.valueOf(this.port.getContainerPort()))).endBackend()).endPath()).endHttp()).endRule();
        } else {
            spec.accept((Visitor)new HostVisitor(meta));
        }
    }

    private class PathVisitor
    extends TypedVisitor<HTTPIngressPathBuilder> {
        private final ObjectMeta meta;

        public PathVisitor(ObjectMeta meta) {
            this.meta = meta;
        }

        public void visit(HTTPIngressPathBuilder path) {
            ((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)path.withNewBackend().withServiceName(this.meta.getName())).withNewServicePort(Integer.valueOf(AddIngressRuleDecorator.this.port.getContainerPort()))).endBackend();
        }
    }

    private class HostVisitor
    extends TypedVisitor<IngressRuleBuilder> {
        private final ObjectMeta meta;

        public HostVisitor(ObjectMeta meta) {
            this.meta = meta;
        }

        public void visit(IngressRuleBuilder rule) {
            Predicate mathcingPath = r -> r.getPath().equals(AddIngressRuleDecorator.this.port.getPath());
            if (rule.getHost().equals(AddIngressRuleDecorator.this.host)) {
                if (!rule.editOrNewHttp().hasMatchingPath(mathcingPath).booleanValue()) {
                    ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)rule.editHttp().addNewPath().withNewBackend().withServiceName(this.meta.getName())).withNewServicePort(Integer.valueOf(AddIngressRuleDecorator.this.port.getContainerPort()))).endBackend()).endPath()).endHttp();
                } else {
                    rule.accept((Visitor)new PathVisitor(this.meta));
                }
            }
        }
    }
}

