/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.EditableEnv;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.EnvFluentImpl;
import java.util.Objects;

public class EnvBuilder
extends EnvFluentImpl<EnvBuilder>
implements VisitableBuilder<Env, EnvBuilder> {
    EnvFluent<?> fluent;
    Boolean validationEnabled;

    public EnvBuilder() {
        this(true);
    }

    public EnvBuilder(Boolean validationEnabled) {
        this(new Env(), validationEnabled);
    }

    public EnvBuilder(EnvFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EnvBuilder(EnvFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Env(), validationEnabled);
    }

    public EnvBuilder(EnvFluent<?> fluent, Env instance) {
        this(fluent, instance, true);
    }

    public EnvBuilder(EnvFluent<?> fluent, Env instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withSecret(instance.getSecret());
        fluent.withConfigmap(instance.getConfigmap());
        fluent.withField(instance.getField());
        this.validationEnabled = validationEnabled;
    }

    public EnvBuilder(Env instance) {
        this(instance, (Boolean)true);
    }

    public EnvBuilder(Env instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withSecret(instance.getSecret());
        this.withConfigmap(instance.getConfigmap());
        this.withField(instance.getField());
        this.validationEnabled = validationEnabled;
    }

    public EditableEnv build() {
        EditableEnv buildable = new EditableEnv(this.fluent.getName(), this.fluent.getValue(), this.fluent.getSecret(), this.fluent.getConfigmap(), this.fluent.getField());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvBuilder that = (EnvBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

