/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.AccessMode;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.PersistentVolumeClaimConfigBuilder;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class PersistentVolumeClaimConfig
extends ApplicationConfiguration {
    private int size = 1;
    private String unit = "Gi";
    private String storageClass = "standard";
    private AccessMode accessMode = AccessMode.ReadWriteOnce;
    private Label[] matchLabels = new Label[0];

    public PersistentVolumeClaimConfig() {
    }

    public PersistentVolumeClaimConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, int size, String unit, String storageClass, AccessMode accessMode, Label[] matchLabels) {
        super(project, attributes, partOf, name, version);
        this.size = size;
        this.unit = unit != null ? unit : "Gi";
        this.storageClass = storageClass != null ? storageClass : "standard";
        this.accessMode = accessMode != null ? accessMode : AccessMode.ReadWriteOnce;
        this.matchLabels = matchLabels != null ? matchLabels : new Label[]{};
    }

    public int getSize() {
        return this.size;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Label[] getMatchLabels() {
        return this.matchLabels;
    }

    public static PersistentVolumeClaimConfigBuilder newPersistentVolumeClaimConfigBuilder() {
        return new PersistentVolumeClaimConfigBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimConfig that = (PersistentVolumeClaimConfig)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) {
            return false;
        }
        if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) {
            return false;
        }
        if (this.accessMode != null ? !this.accessMode.equals((Object)that.accessMode) : that.accessMode != null) {
            return false;
        }
        return !(this.matchLabels != null ? !this.matchLabels.equals(that.matchLabels) : that.matchLabels != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.unit, this.storageClass, this.accessMode, this.matchLabels, super.hashCode()});
    }
}

