/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.PortBuilder;
import java.util.Arrays;
import java.util.List;

public class ApplyContainerPort
extends Configurator<BaseConfigFluent<?>> {
    private static final String FALLBACK_PORT_NAME = "http";
    private final int containerPort;
    private final List<String> names;

    public ApplyContainerPort(int containerPort, List<String> names) {
        this.containerPort = containerPort;
        this.names = names;
    }

    public ApplyContainerPort(int containerPort, String ... names) {
        this(containerPort, Arrays.asList(names));
    }

    public void visit(BaseConfigFluent<?> config) {
        Predicate predicate = p -> this.names.contains(p.getName());
        if (config.hasMatchingPort((Predicate<PortBuilder>)predicate).booleanValue()) {
            ((BaseConfigFluent.PortsNested)config.editMatchingPort((Predicate<PortBuilder>)predicate).withContainerPort(this.containerPort)).endPort();
        } else {
            String name = this.names.size() > 0 ? this.names.get(0) : FALLBACK_PORT_NAME;
            ((BaseConfigFluent.PortsNested)((BaseConfigFluent.PortsNested)config.addNewPort().withName(name)).withContainerPort(this.containerPort)).endPort();
        }
    }
}

