/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Builder;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Metadata;
import java.util.Arrays;

@Description(value="Add a label to the matching resources (filtered by name and/or kinds).")
public class AddLabelDecorator
extends NamedResourceDecorator<VisitableBuilder> {
    private final Label label;

    public AddLabelDecorator(Label label) {
        this(ANY, label);
    }

    public AddLabelDecorator(String name, Label label) {
        super(ANY, name);
        this.label = label;
    }

    public AddLabelDecorator(String name, String key, String value, String ... kinds) {
        super(ANY, name);
        this.label = new Label(key, value, kinds);
    }

    @Override
    public void andThenVisit(VisitableBuilder builder, String kind, ObjectMeta resourceMeta) {
        if (this.label.getKinds() == null || this.label.getKinds().length == 0 || Arrays.asList(this.label.getKinds()).contains(kind)) {
            this.andThenVisit(builder, resourceMeta);
        }
    }

    @Override
    public void andThenVisit(VisitableBuilder builder, ObjectMeta resourceMeta) {
        Metadata.addToLabels((Builder)builder, (String)this.label.getKey(), (String)this.label.getValue());
    }

    public Label getLabel() {
        return this.label;
    }

    public String getLabelKey() {
        return this.label.getKey();
    }

    @Override
    public Class<? extends Decorator>[] before() {
        return new Class[]{RemoveLabelDecorator.class};
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddLabelDecorator other = (AddLabelDecorator)obj;
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

