/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigFluent;
import io.dekorate.kubernetes.config.KubernetesConfigFluentImpl;

public class KubernetesConfigBuilder
extends KubernetesConfigFluentImpl<KubernetesConfigBuilder>
implements VisitableBuilder<KubernetesConfig, KubernetesConfigBuilder> {
    KubernetesConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesConfigBuilder() {
        this(true);
    }

    public KubernetesConfigBuilder(Boolean validationEnabled) {
        this(new KubernetesConfig(), validationEnabled);
    }

    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesConfig(), validationEnabled);
    }

    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent, KubernetesConfig instance) {
        this(fluent, instance, true);
    }

    public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent, KubernetesConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withGroup(instance.getGroup());
        fluent.withName(instance.getName());
        fluent.withVersion(instance.getVersion());
        fluent.withInitContainers(instance.getInitContainers());
        fluent.withLabels(instance.getLabels());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withEnvVars(instance.getEnvVars());
        fluent.withWorkingDir(instance.getWorkingDir());
        fluent.withCommand(instance.getCommand());
        fluent.withArguments(instance.getArguments());
        fluent.withReplicas(instance.getReplicas());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withHost(instance.getHost());
        fluent.withPorts(instance.getPorts());
        fluent.withServiceType(instance.getServiceType());
        fluent.withPvcVolumes(instance.getPvcVolumes());
        fluent.withSecretVolumes(instance.getSecretVolumes());
        fluent.withConfigMapVolumes(instance.getConfigMapVolumes());
        fluent.withGitRepoVolumes(instance.getGitRepoVolumes());
        fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        fluent.withAzureFileVolumes(instance.getAzureFileVolumes());
        fluent.withMounts(instance.getMounts());
        fluent.withImagePullPolicy(instance.getImagePullPolicy());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withSidecars(instance.getSidecars());
        fluent.withExpose(instance.isExpose());
        fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        fluent.withDockerFile(instance.getDockerFile());
        fluent.withRegistry(instance.getRegistry());
        fluent.withAutoPushEnabled(instance.isAutoPushEnabled());
        fluent.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesConfigBuilder(KubernetesConfig instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesConfigBuilder(KubernetesConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withInitContainers(instance.getInitContainers());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withReplicas(instance.getReplicas());
        this.withServiceAccount(instance.getServiceAccount());
        this.withHost(instance.getHost());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withSidecars(instance.getSidecars());
        this.withExpose(instance.isExpose());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.withDockerFile(instance.getDockerFile());
        this.withRegistry(instance.getRegistry());
        this.withAutoPushEnabled(instance.isAutoPushEnabled());
        this.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        this.validationEnabled = validationEnabled;
    }

    public EditableKubernetesConfig build() {
        EditableKubernetesConfig buildable = new EditableKubernetesConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getGroup(), this.fluent.getName(), this.fluent.getVersion(), this.fluent.getInitContainers(), this.fluent.getLabels(), this.fluent.getAnnotations(), this.fluent.getEnvVars(), this.fluent.getWorkingDir(), this.fluent.getCommand(), this.fluent.getArguments(), this.fluent.getReplicas(), this.fluent.getServiceAccount(), this.fluent.getHost(), this.fluent.getPorts(), this.fluent.getServiceType(), this.fluent.getPvcVolumes(), this.fluent.getSecretVolumes(), this.fluent.getConfigMapVolumes(), this.fluent.getGitRepoVolumes(), this.fluent.getAwsElasticBlockStoreVolumes(), this.fluent.getAzureDiskVolumes(), this.fluent.getAzureFileVolumes(), this.fluent.getMounts(), this.fluent.getImagePullPolicy(), this.fluent.getLivenessProbe(), this.fluent.getReadinessProbe(), this.fluent.getSidecars(), this.fluent.isExpose(), this.fluent.isAutoDeployEnabled(), this.fluent.getDockerFile(), this.fluent.getRegistry(), this.fluent.isAutoPushEnabled(), this.fluent.isAutoBuildEnabled());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesConfigBuilder that = (KubernetesConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

