/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.deps.kubernetes.api.model.VolumeFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.decorator.Decorator;

@Description(value="Add an Azure File volume to the Pod spec.")
public class AddAzureFileVolumeDecorator
extends Decorator<PodSpecBuilder> {
    private final AzureFileVolume volume;

    public AddAzureFileVolumeDecorator(AzureFileVolume volume) {
        this.volume = volume;
    }

    public void visit(PodSpecBuilder podSpec) {
        ((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewAzureFile().withSecretName(this.volume.getSecretName())).withShareName(this.volume.getShareName())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endAzureFile();
    }
}

