/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.ContainerBuilder;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.EnvVarFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.utils.Strings;
import java.util.Objects;

@Description(value="Add a environment variable to the container.")
public class AddEnvVarDecorator
extends ApplicationContainerDecorator<ContainerBuilder> {
    private final Env env;

    public AddEnvVarDecorator(Env env) {
        this(ANY, ANY, env);
    }

    public AddEnvVarDecorator(String deployment, String container, Env env) {
        super(deployment, container);
        this.env = env;
    }

    @Override
    public void andThenVisit(ContainerBuilder builder) {
        if (Strings.isNotNullOrEmpty((String)this.env.getSecret())) {
            this.populateFromSecret(builder);
        } else if (Strings.isNotNullOrEmpty((String)this.env.getConfigmap())) {
            this.populateFromConfigMap(builder);
        } else if (Strings.isNotNullOrEmpty((String)this.env.getField())) {
            ((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewFieldRef(null, this.env.getField())).endValueFrom();
        } else if (Strings.isNotNullOrEmpty((String)this.env.getName())) {
            ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withValue(this.env.getValue())).endEnv();
        }
    }

    private void populateFromSecret(ContainerBuilder builder) {
        if (Strings.isNotNullOrEmpty((String)this.env.getName()) && Strings.isNotNullOrEmpty((String)this.env.getValue())) {
            ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewSecretKeyRef(this.env.getValue(), this.env.getSecret(), Boolean.valueOf(false))).endValueFrom()).endEnv();
        } else {
            ((ContainerFluent.EnvFromNested)builder.addNewEnvFrom().withNewSecretRef(this.env.getSecret(), Boolean.valueOf(false))).endEnvFrom();
        }
    }

    private void populateFromConfigMap(ContainerBuilder builder) {
        if (Strings.isNotNullOrEmpty((String)this.env.getName()) && Strings.isNotNullOrEmpty((String)this.env.getValue())) {
            ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewConfigMapKeyRef(this.env.getValue(), this.env.getConfigmap(), Boolean.valueOf(false))).endValueFrom()).endEnv();
        } else {
            ((ContainerFluent.EnvFromNested)builder.addNewEnvFrom().withNewConfigMapRef(this.env.getConfigmap(), Boolean.valueOf(false))).endEnvFrom();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddEnvVarDecorator addEnvVarDecorator = (AddEnvVarDecorator)o;
        return Objects.equals(this.env, addEnvVarDecorator.env);
    }

    public int hashCode() {
        return Objects.hash(this.env);
    }
}

