/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.handler;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.EnvVarFluent;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpec;
import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpec;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.dekorate.deps.kubernetes.api.model.apps.Deployment;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentBuilder;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentFluent;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.configurator.ApplyAutoBuild;
import io.dekorate.kubernetes.decorator.AddIngressDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyLabelSelectorDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import java.util.Optional;

public class KubernetesHandler
extends AbstractKubernetesHandler<KubernetesConfig>
implements HandlerFactory,
WithProject {
    private static final String KUBERNETES = "kubernetes";
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";

    public KubernetesHandler() {
        this(new Resources());
    }

    public KubernetesHandler(Resources resources) {
        super(resources);
    }

    public Handler create(Resources resources) {
        return new KubernetesHandler(resources);
    }

    public int order() {
        return 200;
    }

    public void handle(KubernetesConfig config) {
        this.setApplicationInfo(config);
        Optional<Deployment> existingDeployment = this.resources.groups().getOrDefault(KUBERNETES, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Deployment).map(i -> (Deployment)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeployment.isPresent()) {
            this.resources.add(KUBERNETES, (HasMetadata)this.createDeployment(config));
        }
        this.addDecorators(KUBERNETES, config);
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        this.resources.decorate(group, (Decorator)new AddIngressDecorator(config, this.resources.getLabels()));
        this.resources.decorate(group, (Decorator)new ApplyLabelSelectorDecorator(this.createSelector()));
        if (Strings.isNotNullOrEmpty((String)config.getRegistry())) {
            this.resources.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), config.getRegistry() + "/" + config.getGroup() + "/" + config.getName() + ":" + config.getVersion()));
        } else if (config.isAutoPushEnabled()) {
            this.resources.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), "docker.io/" + config.getGroup() + "/" + config.getName() + ":" + config.getVersion()));
        } else {
            this.resources.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), config.getGroup() + "/" + config.getName() + ":" + config.getVersion()));
        }
    }

    public Deployment createDeployment(KubernetesConfig config) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(config.getName())).withLabels(this.resources.getLabels())).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(KubernetesHandler.createPodTemplateSpec(config))).withSelector(this.createSelector())).endSpec()).build();
    }

    public LabelSelector createSelector() {
        return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(this.resources.getLabels())).build();
    }

    public static PodTemplateSpec createPodTemplateSpec(KubernetesConfig config) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(KubernetesHandler.createPodSpec(config))).withNewMetadata().withLabels(Labels.createLabels((BaseConfig)config))).endMetadata()).build();
    }

    public static PodSpec createPodSpec(KubernetesConfig config) {
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage(config.getGroup() + "/" + config.getName() + ":" + config.getVersion())).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }

    public ConfigurationSupplier<KubernetesConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().accept((Visitor)new ApplyAutoBuild())).accept((Visitor)new ApplyProjectInfo(p)));
    }
}

