/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.hook;

import io.dekorate.hook.ProjectHook;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import java.io.File;

public class DockerBuildHook
extends ProjectHook {
    private final File dockerFile;
    private final String image;

    public DockerBuildHook(Project project, KubernetesConfig config) {
        super(project);
        this.dockerFile = project.getRoot().resolve(config.getDockerFile()).toFile();
        this.image = Images.getImage((String)config.getRegistry(), (String)config.getGroup(), (String)config.getName(), (String)config.getVersion());
    }

    public void init() {
    }

    public void warmup() {
    }

    public void run() {
        this.exec(new String[]{"docker", "build", "-f" + this.dockerFile.getAbsolutePath(), "-t" + this.image, this.project.getRoot().toAbsolutePath().toString()});
    }
}

