/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.BaseConfigFluentImpl;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KubernetesConfigFluentImpl<A extends KubernetesConfigFluent<A>>
extends BaseConfigFluentImpl<A>
implements KubernetesConfigFluent<A> {
    private List<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
    private int replicas = 1;

    public KubernetesConfigFluentImpl() {
    }

    public KubernetesConfigFluentImpl(KubernetesConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withLabels(instance.getLabels());
        this.withAnnotations(instance.getAnnotations());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withServiceAccount(instance.getServiceAccount());
        this.withHost(instance.getHost());
        this.withPorts(instance.getPorts());
        this.withServiceType(instance.getServiceType());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withGitRepoVolumes(instance.getGitRepoVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withSidecars(instance.getSidecars());
        this.withExpose(instance.isExpose());
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled());
        this.withInitContainers(instance.getInitContainers());
        this.withReplicas(instance.getReplicas());
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Container[] getInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container[] buildInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"initContainers").add(index >= 0 ? index : this._visitables.get((Object)"initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"initContainers").size()) {
            this._visitables.get((Object)"initContainers").add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.apply((Object)this.initContainers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(int replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesConfigFluentImpl that = (KubernetesConfigFluentImpl)o;
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        return this.replicas == that.replicas;
    }

    public class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<KubernetesConfigFluent.InitContainersNested<N>>
    implements KubernetesConfigFluent.InitContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        InitContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesConfigFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }
}

