/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.kubernetes.adapter.KubernetesConfigAdapter;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.configurator.ApplyBuildToImageConfiguration;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.handler.KubernetesHandler;
import io.dekorate.kubernetes.listener.KubernetesSessionListener;
import io.dekorate.project.ApplyProjectInfo;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface KubernetesApplicationGenerator
extends Generator,
WithProject {
    public static final String KUBERNETES = "kubernetes";
    public static final KubernetesSessionListener LISTENER = new KubernetesSessionListener();

    default public String getKey() {
        return KUBERNETES;
    }

    default public Class<? extends Annotation> getAnnotation() {
        return KubernetesApplication.class;
    }

    default public void add(Map map) {
        this.add((ConfigurationSupplier<KubernetesConfig>)new PropertyConfiguration((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(this.propertiesMap(map, KubernetesApplication.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(Element element) {
        KubernetesApplication application = element.getAnnotation(KubernetesApplication.class);
        this.add((ConfigurationSupplier<KubernetesConfig>)new AnnotationConfiguration((VisitableBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)KubernetesConfigAdapter.newBuilder(application).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(ConfigurationSupplier<KubernetesConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.handlers().add(new KubernetesHandler(session.resources(), session.configurators()));
        session.addListener((SessionListener)LISTENER);
    }
}

