/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentBuilder;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Images;

public class ApplyRegistryToImageDecorator
extends Decorator<DeploymentBuilder> {
    private final String registry;
    private final String group;
    private final String name;
    private final String version;

    public ApplyRegistryToImageDecorator(String registry, String group, String name, String version) {
        this.registry = registry;
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public void visit(DeploymentBuilder deployment) {
        if (this.name.equals(deployment.getMetadata().getName())) {
            deployment.accept((Visitor)new Decorator<ContainerFluent>(){

                public void visit(ContainerFluent container) {
                    if (container.getName().equals(ApplyRegistryToImageDecorator.this.name)) {
                        String image = Images.getImage((String)ApplyRegistryToImageDecorator.this.registry, (String)ApplyRegistryToImageDecorator.this.group, (String)ApplyRegistryToImageDecorator.this.name, (String)ApplyRegistryToImageDecorator.this.version);
                        container.withImage(image);
                    }
                }
            });
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ApplyImageDecorator.class};
    }
}

