/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.builder.Builder;
import io.dekorate.deps.kubernetes.api.builder.TypedVisitor;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import java.util.Optional;

public abstract class NamedResourceDecorator<T>
extends Decorator<VisitableBuilder> {
    public static final String ANY = null;
    protected final String name;
    private final ResourceVisitor visitor = new ResourceVisitor(null);

    public NamedResourceDecorator() {
        this(ANY);
    }

    public NamedResourceDecorator(String name) {
        this.name = name;
    }

    public void visit(VisitableBuilder builder) {
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.name)) {
            builder.accept((Visitor)this.visitor.withMetadata((ObjectMeta)objectMeta.get()));
        } else if (objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.name)).isPresent()) {
            builder.accept((Visitor)this.visitor.withMetadata((ObjectMeta)objectMeta.get()));
        }
    }

    public abstract void andThenVisit(T var1, ObjectMeta var2);

    private class ResourceVisitor
    extends TypedVisitor<T> {
        private final ObjectMeta metadata;

        public ResourceVisitor(ObjectMeta metadata) {
            this.metadata = metadata;
        }

        public void visit(T item) {
            NamedResourceDecorator.this.andThenVisit(item, this.metadata);
        }

        public ResourceVisitor withMetadata(ObjectMeta metadata) {
            return new ResourceVisitor(metadata);
        }

        public Class<T> getType() {
            return (Class)Generics.getTypeArguments(NamedResourceDecorator.class, NamedResourceDecorator.this.getClass()).get(0);
        }
    }
}

