/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.kubernetes.decorator.Decorator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ResourceProvidingDecorator<T>
extends Decorator<T> {
    private static final List<String> DEPLOYMENT_KINDS = Arrays.asList("Deployment", "DeploymentConfig", "Service", "Pipeline");

    public Optional<ObjectMeta> getDeploymentMetadata(KubernetesListBuilder list) {
        return list.getItems().stream().filter(h -> DEPLOYMENT_KINDS.contains(h.getKind())).map(HasMetadata::getMetadata).findFirst();
    }

    public ObjectMeta getMandatoryDeploymentMetadata(KubernetesListBuilder list) {
        return this.getDeploymentMetadata(list).orElseThrow(() -> new IllegalStateException("Expected at least one of: " + DEPLOYMENT_KINDS.stream().collect(Collectors.joining(",")) + " to be present."));
    }
}

