/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.EditableJob;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.JobFluent;
import io.dekorate.kubernetes.config.JobFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class JobBuilder
extends JobFluentImpl<JobBuilder>
implements VisitableBuilder<Job, JobBuilder> {
    JobFluent<?> fluent;
    Boolean validationEnabled;

    public JobBuilder() {
        this(false);
    }

    public JobBuilder(Boolean validationEnabled) {
        this(new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public JobBuilder(JobFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance) {
        this(fluent, instance, false);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withParallelism(instance.getParallelism());
        fluent.withCompletions(instance.getCompletions());
        fluent.withCompletionMode(instance.getCompletionMode());
        fluent.withBackoffLimit(instance.getBackoffLimit());
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        fluent.withSuspend(instance.getSuspend());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withPvcVolumes(instance.getPvcVolumes());
        fluent.withSecretVolumes(instance.getSecretVolumes());
        fluent.withConfigMapVolumes(instance.getConfigMapVolumes());
        fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        fluent.withAzureFileVolumes(instance.getAzureFileVolumes());
        fluent.withContainers(instance.getContainers());
        this.validationEnabled = validationEnabled;
    }

    public JobBuilder(Job instance) {
        this(instance, (Boolean)false);
    }

    public JobBuilder(Job instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withParallelism(instance.getParallelism());
        this.withCompletions(instance.getCompletions());
        this.withCompletionMode(instance.getCompletionMode());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.withSuspend(instance.getSuspend());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withContainers(instance.getContainers());
        this.validationEnabled = validationEnabled;
    }

    public EditableJob build() {
        EditableJob buildable = new EditableJob(this.fluent.getName(), this.fluent.getParallelism(), this.fluent.getCompletions(), this.fluent.getCompletionMode(), this.fluent.getBackoffLimit(), this.fluent.getActiveDeadlineSeconds(), this.fluent.getTtlSecondsAfterFinished(), this.fluent.getSuspend(), this.fluent.getRestartPolicy(), this.fluent.getPvcVolumes(), this.fluent.getSecretVolumes(), this.fluent.getConfigMapVolumes(), this.fluent.getAwsElasticBlockStoreVolumes(), this.fluent.getAzureDiskVolumes(), this.fluent.getAzureFileVolumes(), this.fluent.getContainers());
        return buildable;
    }
}

