package io.dekorate.kubernetes.config;

import java.lang.String;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class KubernetesConfig extends BaseConfig{
  public KubernetesConfig() {
  }
  public KubernetesConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,java.lang.String name,java.lang.String version,java.lang.String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,java.lang.String workingDir,java.lang.String[] command,java.lang.String[] arguments,java.lang.String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,java.lang.String[] imagePullSecrets,HostAlias[] hostAliases,Probe livenessProbe,io.dekorate.kubernetes.config.Probe readinessProbe,io.dekorate.kubernetes.config.Probe startupProbe,ResourceRequirements requestResources,io.dekorate.kubernetes.config.ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs,io.dekorate.kubernetes.config.Container[] initContainers,Integer replicas,DeploymentStrategy deploymentStrategy,RollingUpdate rollingUpdate,Ingress ingress,java.lang.Boolean headless) {
    super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
    this.initContainers = initContainers != null ? initContainers : new io.dekorate.kubernetes.config.Container[0];
    this.replicas = replicas;
    this.deploymentStrategy = deploymentStrategy;
    this.rollingUpdate = rollingUpdate;
    this.ingress = ingress;
    this.headless = headless;
  }
  private io.dekorate.kubernetes.config.Container[] initContainers = new io.dekorate.kubernetes.config.Container[0];
  private java.lang.Integer replicas;
  private io.dekorate.kubernetes.config.DeploymentStrategy deploymentStrategy;
  private io.dekorate.kubernetes.config.RollingUpdate rollingUpdate;
  private io.dekorate.kubernetes.config.Ingress ingress;
  private java.lang.Boolean headless;
  
  /**
   * The init containers.
   * @return the init containers.
   */
public io.dekorate.kubernetes.config.Container[] getInitContainers() {
    return this.initContainers;
  }
  
  /**
   * The number of replicas to use.
   * @return The number of replicas.
   */
public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  
  /**
   * Specifies the deployment strategy.
   */
public io.dekorate.kubernetes.config.DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  
  /**
   * Specifies rolling update configuration.
   * The configuration is applied when DeploymentStrategy == Rolling update, or
   * when explicit configuration has been provided. In the later case RollingUpdate is assumed.
   */
public io.dekorate.kubernetes.config.RollingUpdate getRollingUpdate() {
    return this.rollingUpdate;
  }
  
  /**
   * @return the Ingress resource configuration.
   */
public io.dekorate.kubernetes.config.Ingress getIngress() {
    return this.ingress;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public java.lang.Boolean getHeadless() {
    return this.headless;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public boolean isHeadless() {
    return this.headless != null &&  this.headless;
  }
  public static KubernetesConfigBuilder newKubernetesConfigBuilder() {
    return new KubernetesConfigBuilder();
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newKubernetesConfigBuilderFromDefaults() {
    return new io.dekorate.kubernetes.config.KubernetesConfigBuilder().withDeploymentKind("Deployment").withReplicas(1).withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy.None).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withIngress(new io.dekorate.kubernetes.config.Ingress()).withHeadless(false).withAutoDeployEnabled(false);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfig that = (KubernetesConfig) o;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (deploymentStrategy != null ? !deploymentStrategy.equals(that.deploymentStrategy) :that.deploymentStrategy != null) return false;
    if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (headless != null ? !headless.equals(that.headless) :that.headless != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  deploymentStrategy,  rollingUpdate,  ingress,  headless,  super.hashCode());
  }
  
}