/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import java.util.Objects;

public class Container {
    private String image;
    private String name;
    private Env[] envVars = new Env[0];
    private String workingDir;
    private String[] command = new String[0];
    private String[] arguments = new String[0];
    private Port[] ports = new Port[0];
    private Mount[] mounts = new Mount[0];
    private ImagePullPolicy imagePullPolicy;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private Probe startupProbe;
    private ResourceRequirements requestResources;
    private ResourceRequirements limitResources;

    public Container() {
    }

    public Container(String image, String name, Env[] envVars, String workingDir, String[] command, String[] arguments, Port[] ports, Mount[] mounts, ImagePullPolicy imagePullPolicy, Probe livenessProbe, Probe readinessProbe, Probe startupProbe, ResourceRequirements requestResources, ResourceRequirements limitResources) {
        this.image = image;
        this.name = name;
        this.envVars = envVars != null ? envVars : new Env[]{};
        this.workingDir = workingDir;
        this.command = command != null ? command : new String[]{};
        this.arguments = arguments != null ? arguments : new String[]{};
        this.ports = ports != null ? ports : new Port[]{};
        this.mounts = mounts != null ? mounts : new Mount[]{};
        this.imagePullPolicy = imagePullPolicy;
        this.livenessProbe = livenessProbe;
        this.readinessProbe = readinessProbe;
        this.startupProbe = startupProbe;
        this.requestResources = requestResources;
        this.limitResources = limitResources;
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public Env[] getEnvVars() {
        return this.envVars;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public Mount[] getMounts() {
        return this.mounts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public Probe getStartupProbe() {
        return this.startupProbe;
    }

    public ResourceRequirements getRequestResources() {
        return this.requestResources;
    }

    public ResourceRequirements getLimitResources() {
        return this.limitResources;
    }

    public static ContainerBuilder newBuilder() {
        return new ContainerBuilder();
    }

    public static ContainerBuilder newBuilderFromDefaults() {
        return (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withImagePullPolicy(ImagePullPolicy.IfNotPresent)).withLivenessProbe(new Probe())).withReadinessProbe(new Probe())).withStartupProbe(new Probe())).withRequestResources(new ResourceRequirements())).withLimitResources(new ResourceRequirements());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container that = (Container)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals((Object)that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.startupProbe != null ? !this.startupProbe.equals(that.startupProbe) : that.startupProbe != null) {
            return false;
        }
        if (this.requestResources != null ? !this.requestResources.equals(that.requestResources) : that.requestResources != null) {
            return false;
        }
        return !(this.limitResources != null ? !this.limitResources.equals(that.limitResources) : that.limitResources != null);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.name, this.envVars, this.workingDir, this.command, this.arguments, this.ports, this.mounts, this.imagePullPolicy, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, super.hashCode());
    }
}

