/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import java.util.function.Predicate;

public class AddIngressRuleDecorator
extends NamedResourceDecorator<IngressSpecBuilder> {
    private final String host;
    private final Port port;

    public AddIngressRuleDecorator(String name, String host, Port port) {
        super(name);
        this.host = host;
        this.port = port;
    }

    @Override
    public void andThenVisit(IngressSpecBuilder spec, ObjectMeta meta) {
        Predicate<IngressRuleBuilder> matchingHost = r -> this.host == null && r.getHost() == null || r.getHost() != null && r.getHost().equals(this.host);
        if (!spec.hasMatchingRule(matchingHost).booleanValue()) {
            ((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)spec.addNewRule().withHost(this.host)).withNewHttp().addNewPath().withPathType("Prefix")).withPath(this.port.getPath())).withNewBackend().withNewService().withName(this.name)).withNewPort().withName(this.port.getName())).withNumber(Strings.isNullOrEmpty((String)this.port.getName()) ? this.port.getHostPort() : null)).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule();
        } else {
            spec.accept(new Visitor[]{new HostVisitor(meta)});
        }
    }

    private class ServiceVisitor
    extends TypedVisitor<IngressServiceBackendBuilder> {
        private ServiceVisitor() {
        }

        public void visit(IngressServiceBackendBuilder service) {
            ((IngressServiceBackendFluent.PortNested)((IngressServiceBackendBuilder)service.withName(AddIngressRuleDecorator.this.port.getName())).withNewPort().withNumber(Strings.isNullOrEmpty((String)AddIngressRuleDecorator.this.port.getName()) ? AddIngressRuleDecorator.this.port.getHostPort() : null)).endPort();
        }
    }

    private class PathVisitor
    extends TypedVisitor<HTTPIngressPathBuilder> {
        private PathVisitor() {
        }

        public void visit(HTTPIngressPathBuilder path) {
            if (path.equals((Object)AddIngressRuleDecorator.this.port.getPath())) {
                if (!path.hasBackend().booleanValue()) {
                    ((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)path.withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.name)).withNewPort().withName(AddIngressRuleDecorator.this.port.getName())).withNumber(Strings.isNullOrEmpty((String)AddIngressRuleDecorator.this.port.getName()) ? AddIngressRuleDecorator.this.port.getHostPort() : null)).endPort()).endService()).endBackend();
                } else {
                    path.accept(new Visitor[]{new ServiceVisitor()});
                }
            }
        }
    }

    private class HostVisitor
    extends TypedVisitor<IngressRuleBuilder> {
        private final ObjectMeta meta;

        public HostVisitor(ObjectMeta meta) {
            this.meta = meta;
        }

        public void visit(IngressRuleBuilder rule) {
            Predicate<HTTPIngressPathBuilder> matchingPath = r -> r.getPath() != null && r.getPath().equals(AddIngressRuleDecorator.this.port.getPath());
            if (rule.getHost() != null && rule.getHost().equals(AddIngressRuleDecorator.this.host)) {
                if (!rule.hasHttp().booleanValue()) {
                    ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)rule.withNewHttp().addNewPath().withPathType("Prefix")).withPath(Strings.isNotNullOrEmpty((String)AddIngressRuleDecorator.this.port.getPath()) ? AddIngressRuleDecorator.this.port.getPath() : "/")).withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.name)).withNewPort().withName(AddIngressRuleDecorator.this.port.getName())).withNumber(Strings.isNullOrEmpty((String)AddIngressRuleDecorator.this.port.getName()) ? AddIngressRuleDecorator.this.port.getHostPort() : null)).endPort()).endService()).endBackend()).endPath()).endHttp();
                } else {
                    rule.accept(new Visitor[]{new PathVisitor()});
                }
            }
        }
    }
}

