/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.manifest;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ResourceRegistry;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.EditableContainer;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddIngressDecorator;
import io.dekorate.kubernetes.decorator.AddIngressRuleDecorator;
import io.dekorate.kubernetes.decorator.AddIngressTlsDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyDeploymentStrategyDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToDeploymentDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToStatefulSetDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.option.config.VcsConfig;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Git;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.nio.file.Path;
import java.util.Optional;

public class KubernetesManifestGenerator
extends AbstractKubernetesManifestGenerator<KubernetesConfig> {
    private static final String KUBERNETES = "kubernetes";
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private final Logger LOGGER = LoggerFactory.getLogger();

    public KubernetesManifestGenerator(ResourceRegistry resources, ConfigurationRegistry configurators) {
        super(resources, configurators);
        resources.groups().putIfAbsent(KUBERNETES, new KubernetesListBuilder());
    }

    public String getKey() {
        return KUBERNETES;
    }

    public int order() {
        return 200;
    }

    public void generate(KubernetesConfig config) {
        this.LOGGER.info("Processing kubernetes configuration.");
        this.initializeRegistry(config);
        this.addDecorators(KUBERNETES, config);
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        ImageConfiguration imageConfig = this.getImageConfiguration(config);
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        EditableContainer appContainer = ((ContainerBuilder)((ContainerFluent.EnvVarsNested)((ContainerFluent.EnvVarsNested)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(config.getName())).withImage(image)).addNewEnvVar().withName(KUBERNETES_NAMESPACE)).withField(METADATA_NAMESPACE)).endEnvVar()).build();
        Project project = this.getProject();
        Optional vcsConfig = this.configurationRegistry.get(VcsConfig.class);
        String remote = vcsConfig.map(VcsConfig::getRemote).orElse("origin");
        boolean httpsPreferred = vcsConfig.map(VcsConfig::isHttpsPreferred).orElse(false);
        String vcsUrl = project.getScmInfo() != null && Strings.isNotNullOrEmpty((String)((String)project.getScmInfo().getRemote().get("origin"))) ? Git.getRemoteUrl((Path)project.getRoot(), (String)remote, (boolean)httpsPreferred).orElse("<<unknown>>") : "<<unknown>>";
        this.resourceRegistry.decorate(group, (Decorator)new AddVcsUrlAnnotationDecorator(config.getName(), "app.dekorate.io/vcs-url", vcsUrl));
        this.resourceRegistry.decorate(group, (Decorator)new AddCommitIdAnnotationDecorator());
        this.resourceRegistry.decorate(group, (Decorator)new ApplyApplicationContainerDecorator(config.getName(), (Container)appContainer));
        this.resourceRegistry.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), image));
        for (Container container : config.getInitContainers()) {
            this.resourceRegistry.decorate(group, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resourceRegistry.decorate(group, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        Ports.getHttpPort((BaseConfig)config).ifPresent(p -> {
            this.resourceRegistry.decorate(group, (Decorator)new AddIngressDecorator(config, Labels.createLabelsAsMap((BaseConfig)config, (String)"Ingress")));
            this.resourceRegistry.decorate(group, (Decorator)new AddIngressRuleDecorator(config.getName(), config.getIngress().getHost(), (Port)p));
        });
        if (config.getIngress() != null && Strings.isNotNullOrEmpty((String)config.getIngress().getTlsSecretName())) {
            this.resourceRegistry.decorate(group, (Decorator)new AddIngressTlsDecorator(config.getName(), config.getIngress()));
        }
        if (config.isHeadless()) {
            this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        if (config.getReplicas() != null && config.getReplicas() != 1) {
            if ("StatefulSet".equalsIgnoreCase(config.getDeploymentKind())) {
                this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyReplicasToStatefulSetDecorator(config.getName(), config.getReplicas().intValue()));
            } else {
                this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyReplicasToDeploymentDecorator(config.getName(), config.getReplicas().intValue()));
            }
        }
        this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyDeploymentStrategyDecorator(config.getName(), config.getDeploymentStrategy(), config.getRollingUpdate()));
    }

    public ConfigurationSupplier<KubernetesConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }
}

