/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.IngressBuilder;
import java.util.Objects;

public class Ingress {
    private String host;
    private Boolean expose;
    private String tlsSecretName;
    private String[] tlsHosts = new String[0];

    public Ingress() {
    }

    public Ingress(String host, Boolean expose, String tlsSecretName, String[] tlsHosts) {
        this.host = host;
        this.expose = expose;
        this.tlsSecretName = tlsSecretName;
        this.tlsHosts = tlsHosts != null ? tlsHosts : new String[]{};
    }

    public String getHost() {
        return this.host;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public boolean isExpose() {
        return this.expose != null && this.expose != false;
    }

    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    public String[] getTlsHosts() {
        return this.tlsHosts;
    }

    public static IngressBuilder newBuilder() {
        return new IngressBuilder();
    }

    public static IngressBuilder newBuilderFromDefaults() {
        return (IngressBuilder)new IngressBuilder().withExpose(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ingress that = (Ingress)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        if (this.tlsSecretName != null ? !this.tlsSecretName.equals(that.tlsSecretName) : that.tlsSecretName != null) {
            return false;
        }
        return !(this.tlsHosts != null ? !this.tlsHosts.equals(that.tlsHosts) : that.tlsHosts != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.expose, this.tlsSecretName, this.tlsHosts, super.hashCode());
    }
}

