/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class IngressFluentImpl<A extends IngressFluent<A>>
extends BaseFluent<A>
implements IngressFluent<A> {
    private String host;
    private Boolean expose;
    private String tlsSecretName;
    private List<String> tlsHosts = new ArrayList<String>();

    public IngressFluentImpl() {
    }

    public IngressFluentImpl(Ingress instance) {
        this.withHost(instance.getHost());
        this.withExpose(instance.getExpose());
        this.withTlsSecretName(instance.getTlsSecretName());
        this.withTlsHosts(instance.getTlsHosts());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public Boolean getExpose() {
        return this.expose;
    }

    @Override
    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)this;
    }

    @Override
    public Boolean hasExpose() {
        return this.expose != null;
    }

    @Override
    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    @Override
    public A withTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
        return (A)this;
    }

    @Override
    public Boolean hasTlsSecretName() {
        return this.tlsSecretName != null;
    }

    @Override
    public A withTlsHosts(String ... tlsHosts) {
        if (this.tlsHosts != null) {
            this.tlsHosts.clear();
        }
        if (tlsHosts != null) {
            for (String item : tlsHosts) {
                this.addToTlsHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getTlsHosts() {
        int size = this.tlsHosts != null ? this.tlsHosts.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.tlsHosts) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToTlsHosts(Integer index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTlsHosts(Integer index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsHosts(String ... items) {
        for (String item : items) {
            if (this.tlsHosts == null) continue;
            this.tlsHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsHosts(Collection<String> items) {
        for (String item : items) {
            if (this.tlsHosts == null) continue;
            this.tlsHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsHosts() {
        return this.tlsHosts != null && !this.tlsHosts.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressFluentImpl that = (IngressFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        if (this.tlsSecretName != null ? !this.tlsSecretName.equals(that.tlsSecretName) : that.tlsSecretName != null) {
            return false;
        }
        return !(this.tlsHosts != null ? !this.tlsHosts.equals(that.tlsHosts) : that.tlsHosts != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.expose, this.tlsSecretName, this.tlsHosts, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.tlsSecretName != null) {
            sb.append("tlsSecretName:");
            sb.append(this.tlsSecretName + ",");
        }
        if (this.tlsHosts != null && !this.tlsHosts.isEmpty()) {
            sb.append("tlsHosts:");
            sb.append(this.tlsHosts);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withExpose() {
        return this.withExpose(true);
    }
}

