/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.manifest;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.BuildServiceFactories;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ResourceRegistry;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.EditableContainer;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddIngressDecorator;
import io.dekorate.kubernetes.decorator.AddIngressRuleDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyDeploymentStrategyDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.option.config.VcsConfig;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Git;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;

public class KubernetesManifestGenerator
extends AbstractKubernetesManifestGenerator<KubernetesConfig>
implements WithProject {
    private static final String KUBERNETES = "kubernetes";
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final ConfigurationRegistry configurationRegistry;

    public KubernetesManifestGenerator(ResourceRegistry resources, ConfigurationRegistry configurators) {
        super(resources);
        this.configurationRegistry = configurators;
        resources.groups().putIfAbsent(KUBERNETES, new KubernetesListBuilder());
    }

    public String getKey() {
        return KUBERNETES;
    }

    public int order() {
        return 200;
    }

    public void generate(KubernetesConfig config) {
        this.LOGGER.info("Processing kubernetes configuration.");
        ImageConfiguration imageConfig = KubernetesManifestGenerator.getImageConfiguration(this.getProject(), config, this.configurationRegistry);
        Optional<Deployment> existingDeployment = this.resourceRegistry.groups().getOrDefault(KUBERNETES, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Deployment).map(i -> (Deployment)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeployment.isPresent()) {
            this.resourceRegistry.add(KUBERNETES, (HasMetadata)this.createDeployment(config, imageConfig));
        }
        this.addDecorators(KUBERNETES, config);
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        ImageConfiguration imageConfig = KubernetesManifestGenerator.getImageConfiguration(this.getProject(), config, this.configurationRegistry);
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        EditableContainer appContainer = ((ContainerBuilder)((ContainerFluent.EnvVarsNested)((ContainerFluent.EnvVarsNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(config.getName())).withImage(image)).withImagePullPolicy(ImagePullPolicy.IfNotPresent)).addNewEnvVar().withName(KUBERNETES_NAMESPACE)).withField(METADATA_NAMESPACE)).endEnvVar()).build();
        Project project = this.getProject();
        Optional vcsConfig = this.configurationRegistry.get(VcsConfig.class);
        String remote = vcsConfig.map(VcsConfig::getRemote).orElse("origin");
        boolean httpsPrefered = vcsConfig.map(VcsConfig::isHttpsPreferred).orElse(false);
        String vcsUrl = project.getScmInfo() != null && Strings.isNotNullOrEmpty((String)((String)project.getScmInfo().getRemote().get("origin"))) ? Git.getRemoteUrl((Path)project.getRoot(), (String)remote, (boolean)httpsPrefered).orElse("<<unknown>>") : "<<unknown>>";
        this.resourceRegistry.decorate(group, (Decorator)new AddVcsUrlAnnotationDecorator(config.getName(), "app.dekorate.io/vcs-url", vcsUrl));
        this.resourceRegistry.decorate(group, (Decorator)new AddCommitIdAnnotationDecorator());
        this.resourceRegistry.decorate(group, (Decorator)new ApplyApplicationContainerDecorator(config.getName(), appContainer));
        this.resourceRegistry.decorate(group, (Decorator)new ApplyImageDecorator(config.getName(), image));
        for (Container container : config.getInitContainers()) {
            this.resourceRegistry.decorate(group, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resourceRegistry.decorate(group, (Decorator)new AddServiceResourceDecorator(config));
        }
        Ports.getHttpPort((BaseConfig)config).ifPresent(p -> {
            this.resourceRegistry.decorate(group, (Decorator)new AddIngressDecorator(config, Labels.createLabelsAsMap((BaseConfig)config, (String)"Ingress")));
            this.resourceRegistry.decorate(group, (Decorator)new AddIngressRuleDecorator(config.getName(), config.getHost(), (Port)p));
        });
        if (config.isHeadless()) {
            this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        if (config.getReplicas() != null && config.getReplicas() != 1) {
            this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyReplicasDecorator(config.getName(), config.getReplicas()));
        }
        this.resourceRegistry.decorate(KUBERNETES, (Decorator)new ApplyDeploymentStrategyDecorator(config.getName(), config.getDeploymentStrategy(), config.getRollingUpdate()));
    }

    public Deployment createDeployment(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appConfig.getName())).endMetadata()).withNewSpec().withReplicas(appConfig.getReplicas())).withNewSelector().withMatchLabels(new HashMap())).endSelector()).withTemplate(KubernetesManifestGenerator.createPodTemplateSpec(appConfig, imageConfig))).endSpec()).build();
    }

    public static PodTemplateSpec createPodTemplateSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(KubernetesManifestGenerator.createPodSpec(appConfig, imageConfig))).withNewMetadata().endMetadata()).build();
    }

    public static PodSpec createPodSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return new PodSpecBuilder().build();
    }

    public ConfigurationSupplier<KubernetesConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    private static ImageConfiguration getImageConfiguration(Project project, KubernetesConfig appConfig, ConfigurationRegistry configurationRegistry) {
        return configurationRegistry.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> KubernetesManifestGenerator.merge(appConfig, i)).orElse(ImageConfiguration.from(appConfig));
    }

    private static ImageConfiguration merge(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        if (appConfig == null) {
            throw new NullPointerException("KubernetesConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from(appConfig);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : appConfig.getProject())).withImage(imageConfig.getImage() != null ? imageConfig.getImage() : null)).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : appConfig.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : appConfig.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : null)).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : "Dockerfile")).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

