/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.project.Project;
import io.dekorate.project.ProjectBuilder;
import io.dekorate.project.ProjectFluent;
import io.dekorate.project.ProjectFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConfigurationFluentImpl<A extends ConfigurationFluent<A>>
extends BaseFluent<A>
implements ConfigurationFluent<A> {
    private ProjectBuilder project;
    private Map<ConfigKey, Object> attributes;

    public ConfigurationFluentImpl() {
    }

    public ConfigurationFluentImpl(Configuration instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
    }

    @Override
    @Deprecated
    public Project getProject() {
        return this.project != null ? this.project.build() : null;
    }

    @Override
    public Project buildProject() {
        return this.project != null ? this.project.build() : null;
    }

    @Override
    public A withProject(Project project) {
        this._visitables.get((Object)"project").remove(this.project);
        if (project != null) {
            this.project = new ProjectBuilder(project);
            this._visitables.get((Object)"project").add(this.project);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProject() {
        return this.project != null;
    }

    @Override
    public ConfigurationFluent.ProjectNested<A> withNewProject() {
        return new ProjectNestedImpl();
    }

    @Override
    public ConfigurationFluent.ProjectNested<A> withNewProjectLike(Project item) {
        return new ProjectNestedImpl(item);
    }

    @Override
    public ConfigurationFluent.ProjectNested<A> editProject() {
        return this.withNewProjectLike(this.getProject());
    }

    @Override
    public ConfigurationFluent.ProjectNested<A> editOrNewProject() {
        return this.withNewProjectLike((Project)(this.getProject() != null ? this.getProject() : new ProjectBuilder().build()));
    }

    @Override
    public ConfigurationFluent.ProjectNested<A> editOrNewProjectLike(Project item) {
        return this.withNewProjectLike(this.getProject() != null ? this.getProject() : item);
    }

    @Override
    public A addToAttributes(ConfigKey key, Object value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttributes(ConfigKey key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (ConfigKey key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<ConfigKey, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public <K, V> A withAttributes(Map<ConfigKey, Object> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<ConfigKey, Object>(attributes);
        return (A)this;
    }

    @Override
    public Boolean hasAttributes() {
        return this.attributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationFluentImpl that = (ConfigurationFluentImpl)o;
        if (this.project != null ? !this.project.equals((Object)that.project) : that.project != null) {
            return false;
        }
        return !(this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.attributes, super.hashCode());
    }

    public class ProjectNestedImpl<N>
    extends ProjectFluentImpl<ConfigurationFluent.ProjectNested<N>>
    implements ConfigurationFluent.ProjectNested<N>,
    Nested<N> {
        private final ProjectBuilder builder;

        ProjectNestedImpl(Project item) {
            this.builder = new ProjectBuilder((ProjectFluent)this, item);
        }

        ProjectNestedImpl() {
            this.builder = new ProjectBuilder((ProjectFluent)this);
        }

        @Override
        public N and() {
            return (N)ConfigurationFluentImpl.this.withProject((Project)this.builder.build());
        }

        @Override
        public N endProject() {
            return this.and();
        }
    }
}

