/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.utils.Ports;
import java.util.Arrays;
import java.util.stream.Collectors;

public class PopulateWebPort
extends Configurator<BaseConfigFluent<?>> {
    public Port map(Port port) {
        if (port.getHostPort() != null && port.getHostPort() > 0) {
            return port;
        }
        if (!Ports.isWebPort((Port)port)) {
            return port;
        }
        return ((PortBuilder)new PortBuilder(port).withHostPort(80)).build();
    }

    public void visit(BaseConfigFluent<?> config) {
        Port[] ports = config.buildPorts();
        config.removeFromPorts(ports);
        config.addAllToPorts(Arrays.stream(ports).map(this::map).collect(Collectors.toList()));
    }
}

