/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesConfigAdapter {
    public static KubernetesConfig adapt(KubernetesApplication instance) {
        return KubernetesConfigAdapter.newBuilder(instance).build();
    }

    public static KubernetesConfigBuilder newBuilder(KubernetesApplication instance) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, instance.partOf(), instance.name(), instance.version(), Arrays.asList(instance.labels()).stream().map(i -> new Label(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Label[0]), Arrays.asList(instance.annotations()).stream().map(i -> new Annotation(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Annotation[0]), Arrays.asList(instance.envVars()).stream().map(i -> new Env(i.name(), i.value(), i.secret(), i.configmap(), i.field(), i.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), instance.workingDir(), instance.command(), instance.arguments(), instance.serviceAccount(), instance.host(), Arrays.asList(instance.ports()).stream().map(i -> new Port(i.name(), Integer.valueOf(i.containerPort()), Integer.valueOf(i.hostPort()), i.path(), i.protocol())).collect(Collectors.toList()).toArray(new Port[0]), instance.serviceType(), Arrays.asList(instance.pvcVolumes()).stream().map(i -> new PersistentVolumeClaimVolume(i.volumeName(), i.claimName(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(instance.secretVolumes()).stream().map(i -> new SecretVolume(i.volumeName(), i.secretName(), Integer.valueOf(i.defaultMode()), Boolean.valueOf(i.optional()))).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(instance.configMapVolumes()).stream().map(i -> new ConfigMapVolume(i.volumeName(), i.configMapName(), Integer.valueOf(i.defaultMode()), Boolean.valueOf(i.optional()))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(instance.gitRepoVolumes()).stream().map(i -> new GitRepoVolume(i.volumeName(), i.repository(), i.directory(), i.revision())).collect(Collectors.toList()).toArray(new GitRepoVolume[0]), Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i -> new AwsElasticBlockStoreVolume(i.volumeName(), i.volumeId(), Integer.valueOf(i.partition()), i.fsType(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(instance.azureDiskVolumes()).stream().map(i -> new AzureDiskVolume(i.volumeName(), i.diskName(), i.diskURI(), i.kind(), i.cachingMode(), i.fsType(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(instance.azureFileVolumes()).stream().map(i -> new AzureFileVolume(i.volumeName(), i.shareName(), i.secretName(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(instance.mounts()).stream().map(i -> new Mount(i.name(), i.path(), i.subPath(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), instance.imagePullPolicy(), instance.imagePullSecrets(), Arrays.asList(instance.hostAliases()).stream().map(i -> new HostAlias(i.ip(), i.hostnames())).collect(Collectors.toList()).toArray(new HostAlias[0]), new Probe(instance.livenessProbe().httpActionPath(), instance.livenessProbe().execAction(), instance.livenessProbe().tcpSocketAction(), Integer.valueOf(instance.livenessProbe().initialDelaySeconds()), Integer.valueOf(instance.livenessProbe().periodSeconds()), Integer.valueOf(instance.livenessProbe().timeoutSeconds()), Integer.valueOf(instance.livenessProbe().successThreshold()), Integer.valueOf(instance.livenessProbe().failureThreshold())), new Probe(instance.readinessProbe().httpActionPath(), instance.readinessProbe().execAction(), instance.readinessProbe().tcpSocketAction(), Integer.valueOf(instance.readinessProbe().initialDelaySeconds()), Integer.valueOf(instance.readinessProbe().periodSeconds()), Integer.valueOf(instance.readinessProbe().timeoutSeconds()), Integer.valueOf(instance.readinessProbe().successThreshold()), Integer.valueOf(instance.readinessProbe().failureThreshold())), new ResourceRequirements(instance.requestResources().memory(), instance.requestResources().cpu()), new ResourceRequirements(instance.limitResources().memory(), instance.limitResources().cpu()), Arrays.asList(instance.sidecars()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), Integer.valueOf(j.containerPort()), Integer.valueOf(j.hostPort()), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), Integer.valueOf(i.livenessProbe().initialDelaySeconds()), Integer.valueOf(i.livenessProbe().periodSeconds()), Integer.valueOf(i.livenessProbe().timeoutSeconds()), Integer.valueOf(i.livenessProbe().successThreshold()), Integer.valueOf(i.livenessProbe().failureThreshold())), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), Integer.valueOf(i.readinessProbe().initialDelaySeconds()), Integer.valueOf(i.readinessProbe().periodSeconds()), Integer.valueOf(i.readinessProbe().timeoutSeconds()), Integer.valueOf(i.readinessProbe().successThreshold()), Integer.valueOf(i.readinessProbe().failureThreshold())), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.expose(), instance.autoDeployEnabled(), Arrays.asList(instance.initContainers()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), Integer.valueOf(j.containerPort()), Integer.valueOf(j.hostPort()), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), Integer.valueOf(i.livenessProbe().initialDelaySeconds()), Integer.valueOf(i.livenessProbe().periodSeconds()), Integer.valueOf(i.livenessProbe().timeoutSeconds()), Integer.valueOf(i.livenessProbe().successThreshold()), Integer.valueOf(i.livenessProbe().failureThreshold())), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), Integer.valueOf(i.readinessProbe().initialDelaySeconds()), Integer.valueOf(i.readinessProbe().periodSeconds()), Integer.valueOf(i.readinessProbe().timeoutSeconds()), Integer.valueOf(i.readinessProbe().successThreshold()), Integer.valueOf(i.readinessProbe().failureThreshold())), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.replicas(), instance.deploymentStrategy(), new RollingUpdate(instance.rollingUpdate().maxUnavailable(), instance.rollingUpdate().maxSurge()), instance.headless()));
    }

    public static KubernetesConfig adapt(Map map) {
        return new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), (String)(i instanceof Map ? i.getOrDefault("secret", null) : null), (String)(i instanceof Map ? i.getOrDefault("configmap", null) : null), (String)(i instanceof Map ? i.getOrDefault("field", null) : null), (String)(i instanceof Map ? i.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("containerPort", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("hostPort", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), i instanceof Map ? (i.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(i.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf((String)String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("claimName", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("defaultMode", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("optional", null) : null))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("configMapName", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("defaultMode", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("optional", null) : null))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("repository", null) : null), (String)(i instanceof Map ? i.getOrDefault("directory", null) : null), (String)(i instanceof Map ? i.getOrDefault("revision", null) : null))).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("volumeId", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("partition", null) : null), (String)(i instanceof Map ? i.getOrDefault("fsType", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskURI", null) : null), (String)(i instanceof Map ? i.getOrDefault("kind", null) : null), (String)(i instanceof Map ? i.getOrDefault("cachingMode", null) : null), (String)(i instanceof Map ? i.getOrDefault("fsType", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("shareName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), (String)(i instanceof Map ? i.getOrDefault("subPath", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias((String)(i instanceof Map ? i.getOrDefault("ip", null) : null), (String)(i instanceof Map ? i.getOrDefault("hostnames", null) : null))).toArray(HostAlias[]::new), new Probe((String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", null) : null)), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), (String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("value", null) : null), (String)(j instanceof Map ? j.getOrDefault("secret", null) : null), (String)(j instanceof Map ? j.getOrDefault("configmap", null) : null), (String)(j instanceof Map ? j.getOrDefault("field", null) : null), (String)(j instanceof Map ? j.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), (String)(i instanceof Map ? i.getOrDefault("workingDir", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("hostPort", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? (j.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(j.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), (String)(j instanceof Map ? j.getOrDefault("subPath", null) : null), (Boolean)(j instanceof Map ? j.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), i instanceof Map ? (i.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(i.getOrDefault("imagePullPolicy", null))) : null) : null, new Probe((String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", null) : null)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", null) : null, map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), (String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("value", null) : null), (String)(j instanceof Map ? j.getOrDefault("secret", null) : null), (String)(j instanceof Map ? j.getOrDefault("configmap", null) : null), (String)(j instanceof Map ? j.getOrDefault("field", null) : null), (String)(j instanceof Map ? j.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), (String)(i instanceof Map ? i.getOrDefault("workingDir", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("hostPort", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? (j.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(j.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), (String)(j instanceof Map ? j.getOrDefault("subPath", null) : null), (Boolean)(j instanceof Map ? j.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), i instanceof Map ? (i.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(i.getOrDefault("imagePullPolicy", null))) : null) : null, new Probe((String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", null) : null)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf(String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", null) : null, (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", null) : null), map instanceof Map ? map.getOrDefault("headless", null) : null);
    }

    public static KubernetesConfigBuilder newBuilder(Map map) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), (String)(i instanceof Map ? i.getOrDefault("secret", null) : null), (String)(i instanceof Map ? i.getOrDefault("configmap", null) : null), (String)(i instanceof Map ? i.getOrDefault("field", null) : null), (String)(i instanceof Map ? i.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, map instanceof Map ? map.getOrDefault("host", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("containerPort", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("hostPort", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), i instanceof Map ? (i.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(i.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf((String)String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("claimName", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("defaultMode", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("optional", null) : null))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("configMapName", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("defaultMode", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("optional", null) : null))).toArray(ConfigMapVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("repository", null) : null), (String)(i instanceof Map ? i.getOrDefault("directory", null) : null), (String)(i instanceof Map ? i.getOrDefault("revision", null) : null))).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("volumeId", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("partition", null) : null), (String)(i instanceof Map ? i.getOrDefault("fsType", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskURI", null) : null), (String)(i instanceof Map ? i.getOrDefault("kind", null) : null), (String)(i instanceof Map ? i.getOrDefault("cachingMode", null) : null), (String)(i instanceof Map ? i.getOrDefault("fsType", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("shareName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), (String)(i instanceof Map ? i.getOrDefault("subPath", null) : null), (Boolean)(i instanceof Map ? i.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias((String)(i instanceof Map ? i.getOrDefault("ip", null) : null), (String)(i instanceof Map ? i.getOrDefault("hostnames", null) : null))).toArray(HostAlias[]::new), new Probe((String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", null) : null)), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), (String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("value", null) : null), (String)(j instanceof Map ? j.getOrDefault("secret", null) : null), (String)(j instanceof Map ? j.getOrDefault("configmap", null) : null), (String)(j instanceof Map ? j.getOrDefault("field", null) : null), (String)(j instanceof Map ? j.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), (String)(i instanceof Map ? i.getOrDefault("workingDir", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("hostPort", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? (j.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(j.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), (String)(j instanceof Map ? j.getOrDefault("subPath", null) : null), (Boolean)(j instanceof Map ? j.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), i instanceof Map ? (i.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(i.getOrDefault("imagePullPolicy", null))) : null) : null, new Probe((String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", null) : null)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("expose", null) : null, map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), (String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("value", null) : null), (String)(j instanceof Map ? j.getOrDefault("secret", null) : null), (String)(j instanceof Map ? j.getOrDefault("configmap", null) : null), (String)(j instanceof Map ? j.getOrDefault("field", null) : null), (String)(j instanceof Map ? j.getOrDefault("resourceField", null) : null))).toArray(Env[]::new), (String)(i instanceof Map ? i.getOrDefault("workingDir", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("hostPort", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? (j.getOrDefault("protocol", null) != null ? Protocol.valueOf((String)String.valueOf(j.getOrDefault("protocol", null))) : null) : null)).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), (String)(j instanceof Map ? j.getOrDefault("subPath", null) : null), (Boolean)(j instanceof Map ? j.getOrDefault("readOnly", null) : null))).toArray(Mount[]::new), i instanceof Map ? (i.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(i.getOrDefault("imagePullPolicy", null))) : null) : null, new Probe((String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new Probe((String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", null) : null), (String)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", null) : null), (Integer)((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", null) : null)), new ResourceRequirements((String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", null) : null), (String)((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", null) : null)))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf(String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", null) : null, (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", null) : null), map instanceof Map ? map.getOrDefault("headless", null) : null));
    }

    public static String[] toStringArray(Object o) {
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.split(",[ ]*");
        }
        if (o instanceof List) {
            List c = (List)o;
            String[] result = new String[c.size()];
            for (int i = 0; i <= c.size(); ++i) {
                result[i] = String.valueOf(c.get(i));
            }
            return result;
        }
        return new String[0];
    }
}

