/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Metadata;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;

@Description(value="Remove a label from the matching resources (filtered by name and/or kinds).")
public class RemoveLabelDecorator
extends NamedResourceDecorator<VisitableBuilder> {
    private final String labelKey;

    public RemoveLabelDecorator(String labelKey) {
        this(ANY, labelKey);
    }

    public RemoveLabelDecorator(String name, String labelKey) {
        super(name);
        this.labelKey = labelKey;
    }

    @Override
    public void andThenVisit(VisitableBuilder builder, ObjectMeta resourceMeta) {
        Metadata.removeFromLabels((Builder)builder, (String)this.labelKey);
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddLabelDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1 + this.getClass().hashCode();
        result = 31 * result + (this.labelKey == null ? 0 : this.labelKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveLabelDecorator other = (RemoveLabelDecorator)obj;
        return !(this.labelKey == null ? other.labelKey != null : !this.labelKey.equals(other.labelKey));
    }
}

