/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;

@Description(value="Add a ServiceAccount resource to the list of generated resources.")
public class AddServiceAccountResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String name;

    public AddServiceAccountResourceDecorator() {
        this(null);
    }

    public AddServiceAccountResourceDecorator(String name) {
        this.name = name;
    }

    public void visit(KubernetesListBuilder list) {
        String name;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        String string = name = Strings.isNotNullOrEmpty((String)this.name) ? this.name : meta.getName();
        if (this.contains(list, "v1", "ServiceAccount", name)) {
            return;
        }
        ((BaseKubernetesListFluent.ServiceAccountItemsNested)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)list.addNewServiceAccountItem().withNewMetadata().withName(name)).withLabels(meta.getLabels())).endMetadata()).endServiceAccountItem();
    }
}

