package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.util.List;
import io.dekorate.kubernetes.annotation.Protocol;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import java.util.stream.Collectors;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.project.BuildInfo;
import java.lang.Object;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

 /**
  * Generated
  */
public class KubernetesConfigAdapter{
  public static io.dekorate.kubernetes.config.KubernetesConfig adapt(io.dekorate.kubernetes.annotation.KubernetesApplication instance) {
    return newBuilder(instance).build();
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newBuilder(io.dekorate.kubernetes.annotation.KubernetesApplication instance) {
    return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(null,
            null,
            instance.partOf(),
            instance.name(),
            instance.version(),
            Arrays.asList(instance.labels()).stream().map(i ->new io.dekorate.kubernetes.config.Label(i.key(),
            i.value(),
            i.kinds())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Label[0]),
            Arrays.asList(instance.annotations()).stream().map(i ->new io.dekorate.kubernetes.config.Annotation(i.key(),
            i.value(),
            i.kinds())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Annotation[0]),
            Arrays.asList(instance.envVars()).stream().map(i ->new io.dekorate.kubernetes.config.Env(i.name(),
            i.value(),
            i.secret(),
            i.configmap(),
            i.field(),
            i.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            instance.workingDir(),
            instance.command(),
            instance.arguments(),
            instance.serviceAccount(),
            instance.host(),
            Arrays.asList(instance.ports()).stream().map(i ->new io.dekorate.kubernetes.config.Port(i.name(),
            i.containerPort(),
            i.hostPort(),
            i.path(),
            i.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            instance.serviceType(),
            Arrays.asList(instance.pvcVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(i.volumeName(),
            i.claimName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[0]),
            Arrays.asList(instance.secretVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.SecretVolume(i.volumeName(),
            i.secretName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.SecretVolume[0]),
            Arrays.asList(instance.configMapVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(i.volumeName(),
            i.configMapName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.ConfigMapVolume[0]),
            Arrays.asList(instance.gitRepoVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(i.volumeName(),
            i.repository(),
            i.directory(),
            i.revision())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.GitRepoVolume[0]),
            Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(i.volumeName(),
            i.volumeId(),
            i.partition(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[0]),
            Arrays.asList(instance.azureDiskVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(i.volumeName(),
            i.diskName(),
            i.diskURI(),
            i.kind(),
            i.cachingMode(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureDiskVolume[0]),
            Arrays.asList(instance.azureFileVolumes()).stream().map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(i.volumeName(),
            i.shareName(),
            i.secretName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureFileVolume[0]),
            Arrays.asList(instance.mounts()).stream().map(i ->new io.dekorate.kubernetes.config.Mount(i.name(),
            i.path(),
            i.subPath(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            instance.imagePullPolicy(),
            instance.imagePullSecrets(),
            Arrays.asList(instance.hostAliases()).stream().map(i ->new io.dekorate.kubernetes.config.HostAlias(i.ip(),
            i.hostnames())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.HostAlias[0]),
            new io.dekorate.kubernetes.config.Probe(instance.livenessProbe().httpActionPath(),
            instance.livenessProbe().execAction(),
            instance.livenessProbe().tcpSocketAction(),
            instance.livenessProbe().initialDelaySeconds(),
            instance.livenessProbe().periodSeconds(),
            instance.livenessProbe().timeoutSeconds(),
            instance.livenessProbe().successThreshold(),
            instance.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(instance.readinessProbe().httpActionPath(),
            instance.readinessProbe().execAction(),
            instance.readinessProbe().tcpSocketAction(),
            instance.readinessProbe().initialDelaySeconds(),
            instance.readinessProbe().periodSeconds(),
            instance.readinessProbe().timeoutSeconds(),
            instance.readinessProbe().successThreshold(),
            instance.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(instance.requestResources().memory(),
            instance.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(instance.limitResources().memory(),
            instance.limitResources().cpu()),
            Arrays.asList(instance.sidecars()).stream().map(i ->new io.dekorate.kubernetes.config.Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field(),
            j.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.requestResources().memory(),
            i.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.limitResources().memory(),
            i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.expose(),
            instance.autoDeployEnabled(),
            Arrays.asList(instance.initContainers()).stream().map(i ->new io.dekorate.kubernetes.config.Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field(),
            j.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.requestResources().memory(),
            i.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.limitResources().memory(),
            i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.replicas(),
            instance.deploymentStrategy(),
            new io.dekorate.kubernetes.config.RollingUpdate(instance.rollingUpdate().maxUnavailable(),
            instance.rollingUpdate().maxSurge()),
            instance.headless()));
  }
  public static io.dekorate.kubernetes.config.KubernetesConfig adapt(java.util.Map map) {
    return new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secret", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("field", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("host", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(i instanceof Map ? ( ((Map)i).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)i).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               (io.dekorate.kubernetes.annotation.ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("directory", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("revision", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("kind", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("hostAliases" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.HostAlias(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("ip", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("hostnames", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.HostAlias[size]),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", null) : null)),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(j instanceof Map ? ( ((Map)j).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)j).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(i instanceof Map ? ( ((Map)i).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)i).getOrDefault("imagePullPolicy", null))) : null ) : null),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", null) : null)))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("expose", null) : null),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(j instanceof Map ? ( ((Map)j).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)j).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(i instanceof Map ? ( ((Map)i).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)i).getOrDefault("imagePullPolicy", null))) : null ) : null),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", null) : null)))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
               (io.dekorate.kubernetes.config.DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
new io.dekorate.kubernetes.config.RollingUpdate(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", null) : null)),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null));
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newBuilder(java.util.Map map) {
    return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secret", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("field", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("host", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(i instanceof Map ? ( ((Map)i).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)i).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               (io.dekorate.kubernetes.annotation.ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("directory", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("revision", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("kind", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("hostAliases" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.HostAlias(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("ip", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("hostnames", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.HostAlias[size]),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", null) : null)),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(j instanceof Map ? ( ((Map)j).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)j).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(i instanceof Map ? ( ((Map)i).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)i).getOrDefault("imagePullPolicy", null))) : null ) : null),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", null) : null)))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("expose", null) : null),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (io.dekorate.kubernetes.annotation.Protocol)(j instanceof Map ? ( ((Map)j).getOrDefault("protocol", null) != null ? io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(((Map)j).getOrDefault("protocol", null))) : null ) : null))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", null) : null))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(i instanceof Map ? ( ((Map)i).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)i).getOrDefault("imagePullPolicy", null))) : null ) : null),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", null) : null),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", null) : null)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", null) : null),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", null) : null)))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
               (io.dekorate.kubernetes.config.DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
new io.dekorate.kubernetes.config.RollingUpdate(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", null) : null),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", null) : null)),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null)));
  }
  public static java.lang.String[] toStringArray(java.lang.Object o) {
            if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

  }
  
}