package io.dekorate.kubernetes.config;

import java.lang.String;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @io.sundr.builder.annotations.Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class KubernetesConfig extends io.dekorate.kubernetes.config.BaseConfig{
  public KubernetesConfig() {
  }
  public KubernetesConfig(io.dekorate.project.Project project,java.util.Map<io.dekorate.kubernetes.config.ConfigKey,java.lang.Object> attributes,java.lang.String partOf,java.lang.String name,java.lang.String version,io.dekorate.kubernetes.config.Label[] labels,io.dekorate.kubernetes.config.Annotation[] annotations,io.dekorate.kubernetes.config.Env[] envVars,java.lang.String workingDir,java.lang.String[] command,java.lang.String[] arguments,java.lang.String serviceAccount,java.lang.String host,io.dekorate.kubernetes.config.Port[] ports,io.dekorate.kubernetes.annotation.ServiceType serviceType,io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[] pvcVolumes,io.dekorate.kubernetes.config.SecretVolume[] secretVolumes,io.dekorate.kubernetes.config.ConfigMapVolume[] configMapVolumes,io.dekorate.kubernetes.config.GitRepoVolume[] gitRepoVolumes,io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,io.dekorate.kubernetes.config.AzureDiskVolume[] azureDiskVolumes,io.dekorate.kubernetes.config.AzureFileVolume[] azureFileVolumes,io.dekorate.kubernetes.config.Mount[] mounts,io.dekorate.kubernetes.annotation.ImagePullPolicy imagePullPolicy,java.lang.String[] imagePullSecrets,io.dekorate.kubernetes.config.HostAlias[] hostAliases,io.dekorate.kubernetes.config.Probe livenessProbe,io.dekorate.kubernetes.config.Probe readinessProbe,io.dekorate.kubernetes.config.ResourceRequirements requestResources,io.dekorate.kubernetes.config.ResourceRequirements limitResources,io.dekorate.kubernetes.config.Container[] sidecars,java.lang.Boolean expose,java.lang.Boolean autoDeployEnabled,io.dekorate.kubernetes.config.Container[] initContainers,java.lang.Integer replicas,io.dekorate.kubernetes.config.DeploymentStrategy deploymentStrategy,io.dekorate.kubernetes.config.RollingUpdate rollingUpdate,java.lang.Boolean headless) {
    super(project, attributes, partOf, name, version, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, host, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, hostAliases, livenessProbe, readinessProbe, requestResources, limitResources, sidecars, expose, autoDeployEnabled);
    this.initContainers = initContainers != null ? initContainers : new io.dekorate.kubernetes.config.Container[0];
    this.replicas = replicas;
    this.deploymentStrategy = deploymentStrategy;
    this.rollingUpdate = rollingUpdate;
    this.headless = headless;
  }
  private io.dekorate.kubernetes.config.Container[] initContainers = new io.dekorate.kubernetes.config.Container[0];
  private java.lang.Integer replicas;
  private io.dekorate.kubernetes.config.DeploymentStrategy deploymentStrategy;
  private io.dekorate.kubernetes.config.RollingUpdate rollingUpdate;
  private java.lang.Boolean headless;
  
  /**
   * The init containers.
   * @return the init containers.
   */
public io.dekorate.kubernetes.config.Container[] getInitContainers() {
    return this.initContainers;
  }
  
  /**
   * The number of replicas to use.
   * @return The number of replicas.
   */
public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  
  /**
   * Specifies the deployment strategy.
   */
public io.dekorate.kubernetes.config.DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  
  /**
   * Specifies rolling update configuration.
   * The configuration is applied when DeploymentStrategy == Rolling update, or
   * when explicit configuration has been provided. In the later case RollingUpdate is assumed.
   */
public io.dekorate.kubernetes.config.RollingUpdate getRollingUpdate() {
    return this.rollingUpdate;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public java.lang.Boolean getHeadless() {
    return this.headless;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public boolean isHeadless() {
    return this.headless != null &&  this.headless;
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newKubernetesConfigBuilder() {
    return new io.dekorate.kubernetes.config.KubernetesConfigBuilder();
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newKubernetesConfigBuilderFromDefaults() {
    return new io.dekorate.kubernetes.config.KubernetesConfigBuilder().withReplicas(1).withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy.None).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withExpose(false).withHeadless(false).withAutoDeployEnabled(false);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfig that = (KubernetesConfig) o;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (deploymentStrategy != null ? !deploymentStrategy.equals(that.deploymentStrategy) :that.deploymentStrategy != null) return false;
    if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
    if (headless != null ? !headless.equals(that.headless) :that.headless != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  deploymentStrategy,  rollingUpdate,  headless,  super.hashCode());
  }
  
}