/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.BaseConfigBuilder;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class BaseConfig
extends ApplicationConfiguration {
    private Label[] labels = new Label[0];
    private Annotation[] annotations = new Annotation[0];
    private Env[] envVars = new Env[0];
    private String workingDir;
    private String[] command = new String[0];
    private String[] arguments = new String[0];
    private String serviceAccount;
    private String host;
    private Port[] ports = new Port[0];
    private ServiceType serviceType;
    private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
    private SecretVolume[] secretVolumes = new SecretVolume[0];
    private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
    private GitRepoVolume[] gitRepoVolumes = new GitRepoVolume[0];
    private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
    private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
    private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
    private Mount[] mounts = new Mount[0];
    private ImagePullPolicy imagePullPolicy;
    private String[] imagePullSecrets = new String[0];
    private HostAlias[] hostAliases = new HostAlias[0];
    private Probe livenessProbe;
    private Probe readinessProbe;
    private ResourceRequirements requestResources;
    private ResourceRequirements limitResources;
    private Container[] sidecars = new Container[0];
    private Boolean expose;
    private Boolean autoDeployEnabled;

    public BaseConfig() {
    }

    public BaseConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, Label[] labels, Annotation[] annotations, Env[] envVars, String workingDir, String[] command, String[] arguments, String serviceAccount, String host, Port[] ports, ServiceType serviceType, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, GitRepoVolume[] gitRepoVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Mount[] mounts, ImagePullPolicy imagePullPolicy, String[] imagePullSecrets, HostAlias[] hostAliases, Probe livenessProbe, Probe readinessProbe, ResourceRequirements requestResources, ResourceRequirements limitResources, Container[] sidecars, Boolean expose, Boolean autoDeployEnabled) {
        super(project, attributes, partOf, name, version);
        this.labels = labels != null ? labels : new Label[]{};
        this.annotations = annotations != null ? annotations : new Annotation[]{};
        this.envVars = envVars != null ? envVars : new Env[]{};
        this.workingDir = workingDir;
        this.command = command != null ? command : new String[]{};
        this.arguments = arguments != null ? arguments : new String[]{};
        this.serviceAccount = serviceAccount;
        this.host = host;
        this.ports = ports != null ? ports : new Port[]{};
        this.serviceType = serviceType;
        this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[]{};
        this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[]{};
        this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[]{};
        this.gitRepoVolumes = gitRepoVolumes != null ? gitRepoVolumes : new GitRepoVolume[]{};
        this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[]{};
        this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[]{};
        this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[]{};
        this.mounts = mounts != null ? mounts : new Mount[]{};
        this.imagePullPolicy = imagePullPolicy;
        this.imagePullSecrets = imagePullSecrets != null ? imagePullSecrets : new String[]{};
        this.hostAliases = hostAliases != null ? hostAliases : new HostAlias[]{};
        this.livenessProbe = livenessProbe;
        this.readinessProbe = readinessProbe;
        this.requestResources = requestResources;
        this.limitResources = limitResources;
        this.sidecars = sidecars != null ? sidecars : new Container[]{};
        this.expose = expose;
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Env[] getEnvVars() {
        return this.envVars;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getHost() {
        return this.host;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        return this.pvcVolumes;
    }

    public SecretVolume[] getSecretVolumes() {
        return this.secretVolumes;
    }

    public ConfigMapVolume[] getConfigMapVolumes() {
        return this.configMapVolumes;
    }

    public GitRepoVolume[] getGitRepoVolumes() {
        return this.gitRepoVolumes;
    }

    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes;
    }

    public AzureDiskVolume[] getAzureDiskVolumes() {
        return this.azureDiskVolumes;
    }

    public AzureFileVolume[] getAzureFileVolumes() {
        return this.azureFileVolumes;
    }

    public Mount[] getMounts() {
        return this.mounts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String[] getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public HostAlias[] getHostAliases() {
        return this.hostAliases;
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public ResourceRequirements getRequestResources() {
        return this.requestResources;
    }

    public ResourceRequirements getLimitResources() {
        return this.limitResources;
    }

    public Container[] getSidecars() {
        return this.sidecars;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public boolean isExpose() {
        return this.expose != null && this.expose != false;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null && this.autoDeployEnabled != false;
    }

    public static BaseConfigBuilder newBaseConfigBuilder() {
        return new BaseConfigBuilder();
    }

    public static BaseConfigBuilder newBaseConfigBuilderFromDefaults() {
        return (BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)((BaseConfigBuilder)new BaseConfigBuilder().withServiceType(ServiceType.ClusterIP)).withImagePullPolicy(ImagePullPolicy.IfNotPresent)).withLivenessProbe(new Probe())).withReadinessProbe(new Probe())).withRequestResources(new ResourceRequirements())).withLimitResources(new ResourceRequirements())).withExpose(false)).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseConfig that = (BaseConfig)o;
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.serviceType != null ? !this.serviceType.equals((Object)that.serviceType) : that.serviceType != null) {
            return false;
        }
        if (this.pvcVolumes != null ? !this.pvcVolumes.equals(that.pvcVolumes) : that.pvcVolumes != null) {
            return false;
        }
        if (this.secretVolumes != null ? !this.secretVolumes.equals(that.secretVolumes) : that.secretVolumes != null) {
            return false;
        }
        if (this.configMapVolumes != null ? !this.configMapVolumes.equals(that.configMapVolumes) : that.configMapVolumes != null) {
            return false;
        }
        if (this.gitRepoVolumes != null ? !this.gitRepoVolumes.equals(that.gitRepoVolumes) : that.gitRepoVolumes != null) {
            return false;
        }
        if (this.awsElasticBlockStoreVolumes != null ? !this.awsElasticBlockStoreVolumes.equals(that.awsElasticBlockStoreVolumes) : that.awsElasticBlockStoreVolumes != null) {
            return false;
        }
        if (this.azureDiskVolumes != null ? !this.azureDiskVolumes.equals(that.azureDiskVolumes) : that.azureDiskVolumes != null) {
            return false;
        }
        if (this.azureFileVolumes != null ? !this.azureFileVolumes.equals(that.azureFileVolumes) : that.azureFileVolumes != null) {
            return false;
        }
        if (this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals((Object)that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.requestResources != null ? !this.requestResources.equals(that.requestResources) : that.requestResources != null) {
            return false;
        }
        if (this.limitResources != null ? !this.limitResources.equals(that.limitResources) : that.limitResources != null) {
            return false;
        }
        if (this.sidecars != null ? !this.sidecars.equals(that.sidecars) : that.sidecars != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        return !(this.autoDeployEnabled != null ? !this.autoDeployEnabled.equals(that.autoDeployEnabled) : that.autoDeployEnabled != null);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.annotations, this.envVars, this.workingDir, this.command, this.arguments, this.serviceAccount, this.host, this.ports, this.serviceType, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.gitRepoVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.mounts, this.imagePullPolicy, this.imagePullSecrets, this.hostAliases, this.livenessProbe, this.readinessProbe, this.requestResources, this.limitResources, this.sidecars, this.expose, this.autoDeployEnabled, super.hashCode());
    }
}

